# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from linnworks_api.generated.warehousetransfer_new.models.box_tracking_number import BoxTrackingNumber
from linnworks_api.generated.warehousetransfer_new.models.shipment_transportation_status import ShipmentTransportationStatus
from linnworks_api.generated.warehousetransfer_new.models.transportation_contact import TransportationContact
from typing import Optional, Set
from typing_extensions import Self

class SaveTransportContentRequest(BaseModel):
    """
    SaveTransportContentRequest
    """ # noqa: E501
    pro_number: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=10)]] = Field(default=None, alias="proNumber")
    shipping_method: Optional[StrictInt] = Field(default=None, alias="shippingMethod")
    shipping_carrier_type: Optional[StrictInt] = Field(default=None, alias="shippingCarrierType")
    carrier_id: Optional[StrictInt] = Field(default=None, alias="carrierId")
    contact_person: Optional[TransportationContact] = Field(default=None, alias="contactPerson")
    seller_freight_class_id: Optional[StrictInt] = Field(default=None, alias="sellerFreightClassId")
    freight_ready_date: Optional[datetime] = Field(default=None, alias="freightReadyDate")
    send_pallets: Optional[StrictBool] = Field(default=None, alias="sendPallets")
    pallet_is_stacked: Optional[StrictBool] = Field(default=None, alias="palletIsStacked")
    total_shipment_weight: Optional[StrictInt] = Field(default=None, alias="totalShipmentWeight")
    seller_declared_value: Optional[StrictInt] = Field(default=None, alias="sellerDeclaredValue")
    seller_declared_currency: Optional[StrictStr] = Field(default=None, alias="sellerDeclaredCurrency")
    tracking_numbers: Optional[List[BoxTrackingNumber]] = Field(default=None, alias="trackingNumbers")
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    transportation_status: Optional[ShipmentTransportationStatus] = Field(default=None, alias="transportationStatus")
    __properties: ClassVar[List[str]] = ["proNumber", "shippingMethod", "shippingCarrierType", "carrierId", "contactPerson", "sellerFreightClassId", "freightReadyDate", "sendPallets", "palletIsStacked", "totalShipmentWeight", "sellerDeclaredValue", "sellerDeclaredCurrency", "trackingNumbers", "shipmentId", "transportationStatus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SaveTransportContentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of contact_person
        if self.contact_person:
            _dict['contactPerson'] = self.contact_person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tracking_numbers (list)
        _items = []
        if self.tracking_numbers:
            for _item_tracking_numbers in self.tracking_numbers:
                if _item_tracking_numbers:
                    _items.append(_item_tracking_numbers.to_dict())
            _dict['trackingNumbers'] = _items
        # set to None if pro_number (nullable) is None
        # and model_fields_set contains the field
        if self.pro_number is None and "pro_number" in self.model_fields_set:
            _dict['proNumber'] = None

        # set to None if seller_freight_class_id (nullable) is None
        # and model_fields_set contains the field
        if self.seller_freight_class_id is None and "seller_freight_class_id" in self.model_fields_set:
            _dict['sellerFreightClassId'] = None

        # set to None if freight_ready_date (nullable) is None
        # and model_fields_set contains the field
        if self.freight_ready_date is None and "freight_ready_date" in self.model_fields_set:
            _dict['freightReadyDate'] = None

        # set to None if send_pallets (nullable) is None
        # and model_fields_set contains the field
        if self.send_pallets is None and "send_pallets" in self.model_fields_set:
            _dict['sendPallets'] = None

        # set to None if pallet_is_stacked (nullable) is None
        # and model_fields_set contains the field
        if self.pallet_is_stacked is None and "pallet_is_stacked" in self.model_fields_set:
            _dict['palletIsStacked'] = None

        # set to None if total_shipment_weight (nullable) is None
        # and model_fields_set contains the field
        if self.total_shipment_weight is None and "total_shipment_weight" in self.model_fields_set:
            _dict['totalShipmentWeight'] = None

        # set to None if seller_declared_value (nullable) is None
        # and model_fields_set contains the field
        if self.seller_declared_value is None and "seller_declared_value" in self.model_fields_set:
            _dict['sellerDeclaredValue'] = None

        # set to None if seller_declared_currency (nullable) is None
        # and model_fields_set contains the field
        if self.seller_declared_currency is None and "seller_declared_currency" in self.model_fields_set:
            _dict['sellerDeclaredCurrency'] = None

        # set to None if tracking_numbers (nullable) is None
        # and model_fields_set contains the field
        if self.tracking_numbers is None and "tracking_numbers" in self.model_fields_set:
            _dict['trackingNumbers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SaveTransportContentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "proNumber": obj.get("proNumber"),
            "shippingMethod": obj.get("shippingMethod"),
            "shippingCarrierType": obj.get("shippingCarrierType"),
            "carrierId": obj.get("carrierId"),
            "contactPerson": TransportationContact.from_dict(obj["contactPerson"]) if obj.get("contactPerson") is not None else None,
            "sellerFreightClassId": obj.get("sellerFreightClassId"),
            "freightReadyDate": obj.get("freightReadyDate"),
            "sendPallets": obj.get("sendPallets"),
            "palletIsStacked": obj.get("palletIsStacked"),
            "totalShipmentWeight": obj.get("totalShipmentWeight"),
            "sellerDeclaredValue": obj.get("sellerDeclaredValue"),
            "sellerDeclaredCurrency": obj.get("sellerDeclaredCurrency"),
            "trackingNumbers": [BoxTrackingNumber.from_dict(_item) for _item in obj["trackingNumbers"]] if obj.get("trackingNumbers") is not None else None,
            "shipmentId": obj.get("shipmentId"),
            "transportationStatus": obj.get("transportationStatus")
        })
        return _obj


