# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.warehousetransfer_new.models.shipment_box_record_type import ShipmentBoxRecordType
from typing import Optional, Set
from typing_extensions import Self

class ShipmentItemWithBoxAndPalletViewModel(BaseModel):
    """
    ShipmentItemWithBoxAndPalletViewModel
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="shipmentId + palletId + boxId + stockItemId<br>we need this id in UI for ngrx store")
    name: Optional[StrictStr] = None
    shipment_item_id: Optional[StrictInt] = Field(default=None, alias="shipmentItemId")
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    shipment_pallet_id: Optional[StrictInt] = Field(default=None, alias="shipmentPalletId")
    shipment_box_id: Optional[StrictInt] = Field(default=None, alias="shipmentBoxId")
    shipment_box_item_id: Optional[StrictInt] = Field(default=None, alias="shipmentBoxItemId")
    seller_sku: Optional[StrictStr] = Field(default=None, alias="sellerSku")
    sku: Optional[StrictStr] = None
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="stockItemIntId")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="stockItemId")
    title: Optional[StrictStr] = None
    weight: Optional[Union[StrictFloat, StrictInt]] = None
    depth: Optional[Union[StrictFloat, StrictInt]] = None
    height: Optional[Union[StrictFloat, StrictInt]] = None
    width: Optional[Union[StrictFloat, StrictInt]] = None
    quantity_to_ship: Optional[StrictInt] = Field(default=None, alias="quantityToShip")
    thumbnail_source: Optional[StrictStr] = Field(default=None, alias="thumbnailSource")
    batch_bin_racks: Optional[StrictStr] = Field(default=None, alias="batchBinRacks")
    type: Optional[ShipmentBoxRecordType] = None
    pallet_box_hierarchy: Optional[List[StrictStr]] = Field(default=None, alias="palletBoxHierarchy")
    pack_size: Optional[StrictInt] = Field(default=None, alias="packSize")
    tracking_number: Optional[StrictStr] = Field(default=None, alias="trackingNumber")
    __properties: ClassVar[List[str]] = ["id", "name", "shipmentItemId", "shipmentId", "shipmentPalletId", "shipmentBoxId", "shipmentBoxItemId", "sellerSku", "sku", "stockItemIntId", "stockItemId", "title", "weight", "depth", "height", "width", "quantityToShip", "thumbnailSource", "batchBinRacks", "type", "palletBoxHierarchy", "packSize", "trackingNumber"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentItemWithBoxAndPalletViewModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if shipment_pallet_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_pallet_id is None and "shipment_pallet_id" in self.model_fields_set:
            _dict['shipmentPalletId'] = None

        # set to None if shipment_box_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_box_id is None and "shipment_box_id" in self.model_fields_set:
            _dict['shipmentBoxId'] = None

        # set to None if shipment_box_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_box_item_id is None and "shipment_box_item_id" in self.model_fields_set:
            _dict['shipmentBoxItemId'] = None

        # set to None if seller_sku (nullable) is None
        # and model_fields_set contains the field
        if self.seller_sku is None and "seller_sku" in self.model_fields_set:
            _dict['sellerSku'] = None

        # set to None if sku (nullable) is None
        # and model_fields_set contains the field
        if self.sku is None and "sku" in self.model_fields_set:
            _dict['sku'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if thumbnail_source (nullable) is None
        # and model_fields_set contains the field
        if self.thumbnail_source is None and "thumbnail_source" in self.model_fields_set:
            _dict['thumbnailSource'] = None

        # set to None if batch_bin_racks (nullable) is None
        # and model_fields_set contains the field
        if self.batch_bin_racks is None and "batch_bin_racks" in self.model_fields_set:
            _dict['batchBinRacks'] = None

        # set to None if pallet_box_hierarchy (nullable) is None
        # and model_fields_set contains the field
        if self.pallet_box_hierarchy is None and "pallet_box_hierarchy" in self.model_fields_set:
            _dict['palletBoxHierarchy'] = None

        # set to None if tracking_number (nullable) is None
        # and model_fields_set contains the field
        if self.tracking_number is None and "tracking_number" in self.model_fields_set:
            _dict['trackingNumber'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentItemWithBoxAndPalletViewModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "shipmentItemId": obj.get("shipmentItemId"),
            "shipmentId": obj.get("shipmentId"),
            "shipmentPalletId": obj.get("shipmentPalletId"),
            "shipmentBoxId": obj.get("shipmentBoxId"),
            "shipmentBoxItemId": obj.get("shipmentBoxItemId"),
            "sellerSku": obj.get("sellerSku"),
            "sku": obj.get("sku"),
            "stockItemIntId": obj.get("stockItemIntId"),
            "stockItemId": obj.get("stockItemId"),
            "title": obj.get("title"),
            "weight": obj.get("weight"),
            "depth": obj.get("depth"),
            "height": obj.get("height"),
            "width": obj.get("width"),
            "quantityToShip": obj.get("quantityToShip"),
            "thumbnailSource": obj.get("thumbnailSource"),
            "batchBinRacks": obj.get("batchBinRacks"),
            "type": obj.get("type"),
            "palletBoxHierarchy": obj.get("palletBoxHierarchy"),
            "packSize": obj.get("packSize"),
            "trackingNumber": obj.get("trackingNumber")
        })
        return _obj


