# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.csv_separator import CsvSeparator
from linnworks_api.generated.warehousetransfer_new.models.shipment_item_import_row import ShipmentItemImportRow
from linnworks_api.generated.warehousetransfer_new.models.stock_request_item_import_row import StockRequestItemImportRow
from linnworks_api.generated.warehousetransfer_new.models.stock_transfer_item_import_row import StockTransferItemImportRow
from typing import Optional, Set
from typing_extensions import Self

class ShipmentItemsImportMetaFields(BaseModel):
    """
    ShipmentItemsImportMetaFields
    """ # noqa: E501
    csv_separator_mappings: Optional[List[CsvSeparator]] = Field(default=None, alias="csvSeparatorMappings")
    shipment_item_rows: Optional[List[ShipmentItemImportRow]] = Field(default=None, alias="shipmentItemRows")
    stock_request_item_rows: Optional[List[StockRequestItemImportRow]] = Field(default=None, alias="stockRequestItemRows")
    stock_transfer_item_rows: Optional[List[StockTransferItemImportRow]] = Field(default=None, alias="stockTransferItemRows")
    __properties: ClassVar[List[str]] = ["csvSeparatorMappings", "shipmentItemRows", "stockRequestItemRows", "stockTransferItemRows"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentItemsImportMetaFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in csv_separator_mappings (list)
        _items = []
        if self.csv_separator_mappings:
            for _item_csv_separator_mappings in self.csv_separator_mappings:
                if _item_csv_separator_mappings:
                    _items.append(_item_csv_separator_mappings.to_dict())
            _dict['csvSeparatorMappings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in shipment_item_rows (list)
        _items = []
        if self.shipment_item_rows:
            for _item_shipment_item_rows in self.shipment_item_rows:
                if _item_shipment_item_rows:
                    _items.append(_item_shipment_item_rows.to_dict())
            _dict['shipmentItemRows'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in stock_request_item_rows (list)
        _items = []
        if self.stock_request_item_rows:
            for _item_stock_request_item_rows in self.stock_request_item_rows:
                if _item_stock_request_item_rows:
                    _items.append(_item_stock_request_item_rows.to_dict())
            _dict['stockRequestItemRows'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in stock_transfer_item_rows (list)
        _items = []
        if self.stock_transfer_item_rows:
            for _item_stock_transfer_item_rows in self.stock_transfer_item_rows:
                if _item_stock_transfer_item_rows:
                    _items.append(_item_stock_transfer_item_rows.to_dict())
            _dict['stockTransferItemRows'] = _items
        # set to None if csv_separator_mappings (nullable) is None
        # and model_fields_set contains the field
        if self.csv_separator_mappings is None and "csv_separator_mappings" in self.model_fields_set:
            _dict['csvSeparatorMappings'] = None

        # set to None if shipment_item_rows (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_item_rows is None and "shipment_item_rows" in self.model_fields_set:
            _dict['shipmentItemRows'] = None

        # set to None if stock_request_item_rows (nullable) is None
        # and model_fields_set contains the field
        if self.stock_request_item_rows is None and "stock_request_item_rows" in self.model_fields_set:
            _dict['stockRequestItemRows'] = None

        # set to None if stock_transfer_item_rows (nullable) is None
        # and model_fields_set contains the field
        if self.stock_transfer_item_rows is None and "stock_transfer_item_rows" in self.model_fields_set:
            _dict['stockTransferItemRows'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentItemsImportMetaFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "csvSeparatorMappings": [CsvSeparator.from_dict(_item) for _item in obj["csvSeparatorMappings"]] if obj.get("csvSeparatorMappings") is not None else None,
            "shipmentItemRows": [ShipmentItemImportRow.from_dict(_item) for _item in obj["shipmentItemRows"]] if obj.get("shipmentItemRows") is not None else None,
            "stockRequestItemRows": [StockRequestItemImportRow.from_dict(_item) for _item in obj["stockRequestItemRows"]] if obj.get("stockRequestItemRows") is not None else None,
            "stockTransferItemRows": [StockTransferItemImportRow.from_dict(_item) for _item in obj["stockTransferItemRows"]] if obj.get("stockTransferItemRows") is not None else None
        })
        return _obj


