# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ShippingItem(BaseModel):
    """
    ShippingItem
    """ # noqa: E501
    condition_id: Optional[StrictInt] = Field(default=None, alias="conditionId")
    stock_item_id: Optional[StrictInt] = Field(default=None, alias="stockItemId")
    id: Optional[StrictInt] = None
    pack_quantity: Optional[StrictInt] = Field(default=None, alias="packQuantity")
    pack_size: Optional[StrictInt] = Field(default=None, alias="packSize")
    quantity_to_ship: Optional[StrictInt] = Field(default=None, alias="quantityToShip")
    received_qty: Optional[StrictInt] = Field(default=None, alias="receivedQty")
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    seller_sku: Optional[StrictStr] = Field(default=None, alias="sellerSku")
    shipped_qty: Optional[StrictInt] = Field(default=None, alias="shippedQty")
    sku: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["conditionId", "stockItemId", "id", "packQuantity", "packSize", "quantityToShip", "receivedQty", "shipmentId", "sellerSku", "shippedQty", "sku"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShippingItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if condition_id (nullable) is None
        # and model_fields_set contains the field
        if self.condition_id is None and "condition_id" in self.model_fields_set:
            _dict['conditionId'] = None

        # set to None if pack_quantity (nullable) is None
        # and model_fields_set contains the field
        if self.pack_quantity is None and "pack_quantity" in self.model_fields_set:
            _dict['packQuantity'] = None

        # set to None if pack_size (nullable) is None
        # and model_fields_set contains the field
        if self.pack_size is None and "pack_size" in self.model_fields_set:
            _dict['packSize'] = None

        # set to None if seller_sku (nullable) is None
        # and model_fields_set contains the field
        if self.seller_sku is None and "seller_sku" in self.model_fields_set:
            _dict['sellerSku'] = None

        # set to None if sku (nullable) is None
        # and model_fields_set contains the field
        if self.sku is None and "sku" in self.model_fields_set:
            _dict['sku'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShippingItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "conditionId": obj.get("conditionId"),
            "stockItemId": obj.get("stockItemId"),
            "id": obj.get("id"),
            "packQuantity": obj.get("packQuantity"),
            "packSize": obj.get("packSize"),
            "quantityToShip": obj.get("quantityToShip"),
            "receivedQty": obj.get("receivedQty"),
            "shipmentId": obj.get("shipmentId"),
            "sellerSku": obj.get("sellerSku"),
            "shippedQty": obj.get("shippedQty"),
            "sku": obj.get("sku")
        })
        return _obj


