# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.transfer_item_batch_view_model import TransferItemBatchViewModel
from typing import Optional, Set
from typing_extensions import Self

class TransferItemViewModel(BaseModel):
    """
    TransferItemViewModel
    """ # noqa: E501
    pk_transfer_item_id: Optional[StrictInt] = Field(default=None, alias="pkTransferItemId")
    fk_stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="fkStockItemIntId")
    fk_stock_item_id: Optional[StrictStr] = Field(default=None, alias="fkStockItemId")
    sku: Optional[StrictStr] = None
    item_title: Optional[StrictStr] = Field(default=None, alias="itemTitle")
    sent_quantity: Optional[StrictInt] = Field(default=None, alias="sentQuantity")
    received_quantity: Optional[StrictInt] = Field(default=None, alias="receivedQuantity")
    requested_quantity: Optional[StrictInt] = Field(default=None, alias="requestedQuantity")
    in_from_location_quantity: Optional[StrictInt] = Field(default=None, alias="inFromLocationQuantity")
    in_to_location_quantity: Optional[StrictInt] = Field(default=None, alias="inToLocationQuantity")
    due_from_location_quantity: Optional[StrictInt] = Field(default=None, alias="dueFromLocationQuantity")
    thumbnail_source: Optional[StrictStr] = Field(default=None, alias="thumbnailSource")
    batch_type: Optional[StrictInt] = Field(default=None, alias="batchType")
    from_location_batches: Optional[List[TransferItemBatchViewModel]] = Field(default=None, alias="fromLocationBatches")
    to_location_batches: Optional[List[TransferItemBatchViewModel]] = Field(default=None, alias="toLocationBatches")
    __properties: ClassVar[List[str]] = ["pkTransferItemId", "fkStockItemIntId", "fkStockItemId", "sku", "itemTitle", "sentQuantity", "receivedQuantity", "requestedQuantity", "inFromLocationQuantity", "inToLocationQuantity", "dueFromLocationQuantity", "thumbnailSource", "batchType", "fromLocationBatches", "toLocationBatches"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransferItemViewModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in from_location_batches (list)
        _items = []
        if self.from_location_batches:
            for _item_from_location_batches in self.from_location_batches:
                if _item_from_location_batches:
                    _items.append(_item_from_location_batches.to_dict())
            _dict['fromLocationBatches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in to_location_batches (list)
        _items = []
        if self.to_location_batches:
            for _item_to_location_batches in self.to_location_batches:
                if _item_to_location_batches:
                    _items.append(_item_to_location_batches.to_dict())
            _dict['toLocationBatches'] = _items
        # set to None if sku (nullable) is None
        # and model_fields_set contains the field
        if self.sku is None and "sku" in self.model_fields_set:
            _dict['sku'] = None

        # set to None if item_title (nullable) is None
        # and model_fields_set contains the field
        if self.item_title is None and "item_title" in self.model_fields_set:
            _dict['itemTitle'] = None

        # set to None if thumbnail_source (nullable) is None
        # and model_fields_set contains the field
        if self.thumbnail_source is None and "thumbnail_source" in self.model_fields_set:
            _dict['thumbnailSource'] = None

        # set to None if from_location_batches (nullable) is None
        # and model_fields_set contains the field
        if self.from_location_batches is None and "from_location_batches" in self.model_fields_set:
            _dict['fromLocationBatches'] = None

        # set to None if to_location_batches (nullable) is None
        # and model_fields_set contains the field
        if self.to_location_batches is None and "to_location_batches" in self.model_fields_set:
            _dict['toLocationBatches'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransferItemViewModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pkTransferItemId": obj.get("pkTransferItemId"),
            "fkStockItemIntId": obj.get("fkStockItemIntId"),
            "fkStockItemId": obj.get("fkStockItemId"),
            "sku": obj.get("sku"),
            "itemTitle": obj.get("itemTitle"),
            "sentQuantity": obj.get("sentQuantity"),
            "receivedQuantity": obj.get("receivedQuantity"),
            "requestedQuantity": obj.get("requestedQuantity"),
            "inFromLocationQuantity": obj.get("inFromLocationQuantity"),
            "inToLocationQuantity": obj.get("inToLocationQuantity"),
            "dueFromLocationQuantity": obj.get("dueFromLocationQuantity"),
            "thumbnailSource": obj.get("thumbnailSource"),
            "batchType": obj.get("batchType"),
            "fromLocationBatches": [TransferItemBatchViewModel.from_dict(_item) for _item in obj["fromLocationBatches"]] if obj.get("fromLocationBatches") is not None else None,
            "toLocationBatches": [TransferItemBatchViewModel.from_dict(_item) for _item in obj["toLocationBatches"]] if obj.get("toLocationBatches") is not None else None
        })
        return _obj


