# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.amazon_prep_instruction_item import AmazonPrepInstructionItem
from typing import Optional, Set
from typing_extensions import Self

class UpdateShipmentItemPrepInstructionOwnerModel(BaseModel):
    """
    UpdateShipmentItemPrepInstructionOwnerModel
    """ # noqa: E501
    shipment_item_id: Optional[StrictInt] = Field(default=None, alias="shipmentItemId")
    prep_instruction_list: Optional[List[AmazonPrepInstructionItem]] = Field(default=None, alias="prepInstructionList")
    __properties: ClassVar[List[str]] = ["shipmentItemId", "prepInstructionList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateShipmentItemPrepInstructionOwnerModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in prep_instruction_list (list)
        _items = []
        if self.prep_instruction_list:
            for _item_prep_instruction_list in self.prep_instruction_list:
                if _item_prep_instruction_list:
                    _items.append(_item_prep_instruction_list.to_dict())
            _dict['prepInstructionList'] = _items
        # set to None if prep_instruction_list (nullable) is None
        # and model_fields_set contains the field
        if self.prep_instruction_list is None and "prep_instruction_list" in self.model_fields_set:
            _dict['prepInstructionList'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateShipmentItemPrepInstructionOwnerModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "shipmentItemId": obj.get("shipmentItemId"),
            "prepInstructionList": [AmazonPrepInstructionItem.from_dict(_item) for _item in obj["prepInstructionList"]] if obj.get("prepInstructionList") is not None else None
        })
        return _obj


