# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v1

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_new.models.who_preps import WhoPreps
from typing import Optional, Set
from typing_extensions import Self

class UpdateShipmentRequest(BaseModel):
    """
    UpdateShipmentRequest
    """ # noqa: E501
    name: Optional[StrictStr] = None
    shipment_id: Optional[StrictStr] = Field(default=None, alias="shipmentId")
    ship_to: Optional[StrictStr] = Field(default=None, alias="shipTo")
    status_id: StrictInt = Field(alias="statusId")
    who_preps: Optional[WhoPreps] = Field(default=None, alias="whoPreps")
    __properties: ClassVar[List[str]] = ["name", "shipmentId", "shipTo", "statusId", "whoPreps"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateShipmentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if shipment_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_id is None and "shipment_id" in self.model_fields_set:
            _dict['shipmentId'] = None

        # set to None if ship_to (nullable) is None
        # and model_fields_set contains the field
        if self.ship_to is None and "ship_to" in self.model_fields_set:
            _dict['shipTo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateShipmentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "shipmentId": obj.get("shipmentId"),
            "shipTo": obj.get("shipTo"),
            "statusId": obj.get("statusId"),
            "whoPreps": obj.get("whoPreps")
        })
        return _obj


