# linnworks_api.generated.warehousetransfer_v2.StockItemApi

All URIs are relative to *https://eu-api.linnworks.net/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_stock_items_batches_get**](StockItemApi.md#warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_stock_items_batches_get) | **GET** /warehousetransfer/fba-inbound/shipping-plans/{shippingPlanId}/stock-items/batches | GetStockItemBatchesByShippingPlanId


# **warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_stock_items_batches_get**
> List[StockItemBatchResponse] warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_stock_items_batches_get(shipping_plan_id, stock_item_ids=stock_item_ids)

GetStockItemBatchesByShippingPlanId

### Example

* Api Key Authentication (Linnworks):

```python
import linnworks_api.generated.warehousetransfer_v2
from linnworks_api.generated.warehousetransfer_v2.models.stock_item_batch_response import StockItemBatchResponse
from linnworks_api.generated.warehousetransfer_v2.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://eu-api.linnworks.net/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = linnworks_api.generated.warehousetransfer_v2.Configuration(
    host = "https://eu-api.linnworks.net/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Linnworks
configuration.api_key['Linnworks'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Linnworks'] = 'Bearer'

# Enter a context with an instance of the API client
with linnworks_api.generated.warehousetransfer_v2.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = linnworks_api.generated.warehousetransfer_v2.StockItemApi(api_client)
    shipping_plan_id = 56 # int | 
    stock_item_ids = [56] # List[int] |  (optional)

    try:
        # GetStockItemBatchesByShippingPlanId
        api_response = api_instance.warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_stock_items_batches_get(shipping_plan_id, stock_item_ids=stock_item_ids)
        print("The response of StockItemApi->warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_stock_items_batches_get:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling StockItemApi->warehousetransfer_fba_inbound_shipping_plans_shipping_plan_id_stock_items_batches_get: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **shipping_plan_id** | **int**|  | 
 **stock_item_ids** | [**List[int]**](int.md)|  | [optional] 

### Return type

[**List[StockItemBatchResponse]**](StockItemBatchResponse.md)

### Authorization

[Linnworks](../README.md#Linnworks)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**404** | Not Found |  -  |
**405** | Method Not Allowed |  -  |
**500** | Server Error |  -  |
**401** | Unauthorized |  -  |
**403** | Forbidden |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

