# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BinRackResponse(BaseModel):
    """
    BinRackResponse
    """ # noqa: E501
    bin_rack_id: Optional[StrictInt] = Field(default=None, alias="binRackId")
    bin_rack: Optional[StrictStr] = Field(default=None, alias="binRack")
    bin_rack_type_id: Optional[StrictInt] = Field(default=None, alias="binRackTypeId")
    bin_rack_type_name: Optional[StrictStr] = Field(default=None, alias="binRackTypeName")
    routing_sequence: Optional[StrictInt] = Field(default=None, alias="routingSequence")
    __properties: ClassVar[List[str]] = ["binRackId", "binRack", "binRackTypeId", "binRackTypeName", "routingSequence"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BinRackResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if bin_rack (nullable) is None
        # and model_fields_set contains the field
        if self.bin_rack is None and "bin_rack" in self.model_fields_set:
            _dict['binRack'] = None

        # set to None if bin_rack_type_name (nullable) is None
        # and model_fields_set contains the field
        if self.bin_rack_type_name is None and "bin_rack_type_name" in self.model_fields_set:
            _dict['binRackTypeName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BinRackResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "binRackId": obj.get("binRackId"),
            "binRack": obj.get("binRack"),
            "binRackTypeId": obj.get("binRackTypeId"),
            "binRackTypeName": obj.get("binRackTypeName"),
            "routingSequence": obj.get("routingSequence")
        })
        return _obj


