# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.currency_model import CurrencyModel
from linnworks_api.generated.warehousetransfer_v2.models.prep_owner import PrepOwner
from linnworks_api.generated.warehousetransfer_v2.models.prep_type import PrepType
from typing import Optional, Set
from typing_extensions import Self

class PrepInstructionsModel(BaseModel):
    """
    PrepInstructionsModel
    """ # noqa: E501
    fee: Optional[CurrencyModel] = None
    prep_owner: Optional[PrepOwner] = Field(default=None, alias="prepOwner")
    prep_type: Optional[PrepType] = Field(default=None, alias="prepType")
    __properties: ClassVar[List[str]] = ["fee", "prepOwner", "prepType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrepInstructionsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fee
        if self.fee:
            _dict['fee'] = self.fee.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrepInstructionsModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fee": CurrencyModel.from_dict(obj["fee"]) if obj.get("fee") is not None else None,
            "prepOwner": obj.get("prepOwner"),
            "prepType": obj.get("prepType")
        })
        return _obj


