# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.warehousetransfer_v2.models.shipment_box_record_type import ShipmentBoxRecordType
from typing import Optional, Set
from typing_extensions import Self

class ShipmentBoxItemExtendedModel(BaseModel):
    """
    ShipmentBoxItemExtendedModel
    """ # noqa: E501
    id: Optional[StrictStr] = None
    shipping_plan_id: Optional[StrictInt] = Field(default=None, alias="shippingPlanId")
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    packing_group_id: Optional[StrictInt] = Field(default=None, alias="packingGroupId")
    stock_item_int_id: Optional[StrictInt] = Field(default=None, alias="stockItemIntId")
    stock_item_id: Optional[StrictStr] = Field(default=None, alias="stockItemId")
    seller_sku: Optional[StrictStr] = Field(default=None, alias="sellerSku")
    sku: Optional[StrictStr] = None
    weight: Optional[Union[StrictFloat, StrictInt]] = None
    length: Optional[Union[StrictFloat, StrictInt]] = None
    height: Optional[Union[StrictFloat, StrictInt]] = None
    width: Optional[Union[StrictFloat, StrictInt]] = None
    quantity_to_ship: Optional[StrictInt] = Field(default=None, alias="quantityToShip")
    thumbnail_source: Optional[StrictStr] = Field(default=None, alias="thumbnailSource")
    type: Optional[ShipmentBoxRecordType] = None
    data_path: Optional[List[StrictStr]] = Field(default=None, alias="dataPath")
    shipment_box_id: Optional[StrictInt] = Field(default=None, alias="shipmentBoxId")
    shipment_box_item_id: Optional[StrictInt] = Field(default=None, alias="shipmentBoxItemId")
    shipment_box_name: Optional[StrictStr] = Field(default=None, alias="shipmentBoxName")
    title: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "shippingPlanId", "shipmentId", "packingGroupId", "stockItemIntId", "stockItemId", "sellerSku", "sku", "weight", "length", "height", "width", "quantityToShip", "thumbnailSource", "type", "dataPath", "shipmentBoxId", "shipmentBoxItemId", "shipmentBoxName", "title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentBoxItemExtendedModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if shipment_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_id is None and "shipment_id" in self.model_fields_set:
            _dict['shipmentId'] = None

        # set to None if packing_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.packing_group_id is None and "packing_group_id" in self.model_fields_set:
            _dict['packingGroupId'] = None

        # set to None if stock_item_int_id (nullable) is None
        # and model_fields_set contains the field
        if self.stock_item_int_id is None and "stock_item_int_id" in self.model_fields_set:
            _dict['stockItemIntId'] = None

        # set to None if stock_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.stock_item_id is None and "stock_item_id" in self.model_fields_set:
            _dict['stockItemId'] = None

        # set to None if seller_sku (nullable) is None
        # and model_fields_set contains the field
        if self.seller_sku is None and "seller_sku" in self.model_fields_set:
            _dict['sellerSku'] = None

        # set to None if sku (nullable) is None
        # and model_fields_set contains the field
        if self.sku is None and "sku" in self.model_fields_set:
            _dict['sku'] = None

        # set to None if thumbnail_source (nullable) is None
        # and model_fields_set contains the field
        if self.thumbnail_source is None and "thumbnail_source" in self.model_fields_set:
            _dict['thumbnailSource'] = None

        # set to None if data_path (nullable) is None
        # and model_fields_set contains the field
        if self.data_path is None and "data_path" in self.model_fields_set:
            _dict['dataPath'] = None

        # set to None if shipment_box_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_box_id is None and "shipment_box_id" in self.model_fields_set:
            _dict['shipmentBoxId'] = None

        # set to None if shipment_box_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_box_item_id is None and "shipment_box_item_id" in self.model_fields_set:
            _dict['shipmentBoxItemId'] = None

        # set to None if shipment_box_name (nullable) is None
        # and model_fields_set contains the field
        if self.shipment_box_name is None and "shipment_box_name" in self.model_fields_set:
            _dict['shipmentBoxName'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentBoxItemExtendedModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "shippingPlanId": obj.get("shippingPlanId"),
            "shipmentId": obj.get("shipmentId"),
            "packingGroupId": obj.get("packingGroupId"),
            "stockItemIntId": obj.get("stockItemIntId"),
            "stockItemId": obj.get("stockItemId"),
            "sellerSku": obj.get("sellerSku"),
            "sku": obj.get("sku"),
            "weight": obj.get("weight"),
            "length": obj.get("length"),
            "height": obj.get("height"),
            "width": obj.get("width"),
            "quantityToShip": obj.get("quantityToShip"),
            "thumbnailSource": obj.get("thumbnailSource"),
            "type": obj.get("type"),
            "dataPath": obj.get("dataPath"),
            "shipmentBoxId": obj.get("shipmentBoxId"),
            "shipmentBoxItemId": obj.get("shipmentBoxItemId"),
            "shipmentBoxName": obj.get("shipmentBoxName"),
            "title": obj.get("title")
        })
        return _obj


