# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from linnworks_api.generated.warehousetransfer_v2.models.sku_prep_barcode_instruction import SkuPrepBarcodeInstruction
from linnworks_api.generated.warehousetransfer_v2.models.sku_prep_guidance import SkuPrepGuidance
from typing import Optional, Set
from typing_extensions import Self

class ShipmentItemModel(BaseModel):
    """
    ShipmentItemModel
    """ # noqa: E501
    stock_item_id: Optional[StrictInt] = Field(default=None, alias="stockItemId")
    id: Optional[StrictInt] = None
    quantity_to_ship: Optional[StrictInt] = Field(default=None, alias="quantityToShip")
    received_qty: Optional[StrictInt] = Field(default=None, alias="receivedQty")
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    shipped_qty: Optional[StrictInt] = Field(default=None, alias="shippedQty")
    seller_sku: Optional[StrictStr] = Field(default=None, alias="sellerSku")
    sku: Optional[StrictStr] = None
    title: Optional[StrictStr] = None
    barcode_instruction_id: Optional[SkuPrepBarcodeInstruction] = Field(default=None, alias="barcodeInstructionId")
    prep_guidance_id: Optional[SkuPrepGuidance] = Field(default=None, alias="prepGuidanceId")
    unit_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="unitCost")
    __properties: ClassVar[List[str]] = ["stockItemId", "id", "quantityToShip", "receivedQty", "shipmentId", "shippedQty", "sellerSku", "sku", "title", "barcodeInstructionId", "prepGuidanceId", "unitCost"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentItemModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if seller_sku (nullable) is None
        # and model_fields_set contains the field
        if self.seller_sku is None and "seller_sku" in self.model_fields_set:
            _dict['sellerSku'] = None

        # set to None if sku (nullable) is None
        # and model_fields_set contains the field
        if self.sku is None and "sku" in self.model_fields_set:
            _dict['sku'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentItemModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "stockItemId": obj.get("stockItemId"),
            "id": obj.get("id"),
            "quantityToShip": obj.get("quantityToShip"),
            "receivedQty": obj.get("receivedQty"),
            "shipmentId": obj.get("shipmentId"),
            "shippedQty": obj.get("shippedQty"),
            "sellerSku": obj.get("sellerSku"),
            "sku": obj.get("sku"),
            "title": obj.get("title"),
            "barcodeInstructionId": obj.get("barcodeInstructionId"),
            "prepGuidanceId": obj.get("prepGuidanceId"),
            "unitCost": obj.get("unitCost")
        })
        return _obj


