# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.amazon_prep_instruction_item import AmazonPrepInstructionItem
from linnworks_api.generated.warehousetransfer_v2.models.label_owner import LabelOwner
from linnworks_api.generated.warehousetransfer_v2.models.shipment_item_batch_response import ShipmentItemBatchResponse
from typing import Optional, Set
from typing_extensions import Self

class ShipmentItemResponse(BaseModel):
    """
    ShipmentItemResponse
    """ # noqa: E501
    available: Optional[StrictInt] = None
    batches: Optional[List[ShipmentItemBatchResponse]] = None
    batch_type: Optional[StrictInt] = Field(default=None, alias="batchType")
    fba_available: Optional[StrictInt] = Field(default=None, alias="fbaAvailable")
    fba_stock_level: Optional[StrictInt] = Field(default=None, alias="fbaStockLevel")
    fba_total_stock: Optional[StrictInt] = Field(default=None, alias="fbaTotalStock")
    id: Optional[StrictInt] = None
    quantity_to_ship: Optional[StrictInt] = Field(default=None, alias="quantityToShip")
    received_qty: Optional[StrictInt] = Field(default=None, alias="receivedQty")
    asin: Optional[StrictStr] = None
    seller_sku: Optional[StrictStr] = Field(default=None, alias="sellerSku")
    shipment_id: Optional[StrictInt] = Field(default=None, alias="shipmentId")
    shipped_qty: Optional[StrictInt] = Field(default=None, alias="shippedQty")
    sku: Optional[StrictStr] = None
    stock_item_id: Optional[StrictInt] = Field(default=None, alias="stockItemId")
    stock_item_id_guid: Optional[StrictStr] = Field(default=None, alias="stockItemIdGuid")
    thumbnail_source: Optional[StrictStr] = Field(default=None, alias="thumbnailSource")
    title: Optional[StrictStr] = None
    label_owner: Optional[LabelOwner] = Field(default=None, alias="labelOwner")
    prep_instructions: Optional[List[AmazonPrepInstructionItem]] = Field(default=None, alias="prepInstructions")
    __properties: ClassVar[List[str]] = ["available", "batches", "batchType", "fbaAvailable", "fbaStockLevel", "fbaTotalStock", "id", "quantityToShip", "receivedQty", "asin", "sellerSku", "shipmentId", "shippedQty", "sku", "stockItemId", "stockItemIdGuid", "thumbnailSource", "title", "labelOwner", "prepInstructions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShipmentItemResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in batches (list)
        _items = []
        if self.batches:
            for _item_batches in self.batches:
                if _item_batches:
                    _items.append(_item_batches.to_dict())
            _dict['batches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in prep_instructions (list)
        _items = []
        if self.prep_instructions:
            for _item_prep_instructions in self.prep_instructions:
                if _item_prep_instructions:
                    _items.append(_item_prep_instructions.to_dict())
            _dict['prepInstructions'] = _items
        # set to None if batches (nullable) is None
        # and model_fields_set contains the field
        if self.batches is None and "batches" in self.model_fields_set:
            _dict['batches'] = None

        # set to None if asin (nullable) is None
        # and model_fields_set contains the field
        if self.asin is None and "asin" in self.model_fields_set:
            _dict['asin'] = None

        # set to None if seller_sku (nullable) is None
        # and model_fields_set contains the field
        if self.seller_sku is None and "seller_sku" in self.model_fields_set:
            _dict['sellerSku'] = None

        # set to None if sku (nullable) is None
        # and model_fields_set contains the field
        if self.sku is None and "sku" in self.model_fields_set:
            _dict['sku'] = None

        # set to None if stock_item_id_guid (nullable) is None
        # and model_fields_set contains the field
        if self.stock_item_id_guid is None and "stock_item_id_guid" in self.model_fields_set:
            _dict['stockItemIdGuid'] = None

        # set to None if thumbnail_source (nullable) is None
        # and model_fields_set contains the field
        if self.thumbnail_source is None and "thumbnail_source" in self.model_fields_set:
            _dict['thumbnailSource'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if prep_instructions (nullable) is None
        # and model_fields_set contains the field
        if self.prep_instructions is None and "prep_instructions" in self.model_fields_set:
            _dict['prepInstructions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShipmentItemResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "available": obj.get("available"),
            "batches": [ShipmentItemBatchResponse.from_dict(_item) for _item in obj["batches"]] if obj.get("batches") is not None else None,
            "batchType": obj.get("batchType"),
            "fbaAvailable": obj.get("fbaAvailable"),
            "fbaStockLevel": obj.get("fbaStockLevel"),
            "fbaTotalStock": obj.get("fbaTotalStock"),
            "id": obj.get("id"),
            "quantityToShip": obj.get("quantityToShip"),
            "receivedQty": obj.get("receivedQty"),
            "asin": obj.get("asin"),
            "sellerSku": obj.get("sellerSku"),
            "shipmentId": obj.get("shipmentId"),
            "shippedQty": obj.get("shippedQty"),
            "sku": obj.get("sku"),
            "stockItemId": obj.get("stockItemId"),
            "stockItemIdGuid": obj.get("stockItemIdGuid"),
            "thumbnailSource": obj.get("thumbnailSource"),
            "title": obj.get("title"),
            "labelOwner": obj.get("labelOwner"),
            "prepInstructions": [AmazonPrepInstructionItem.from_dict(_item) for _item in obj["prepInstructions"]] if obj.get("prepInstructions") is not None else None
        })
        return _obj


