# coding: utf-8

"""
    Warehouse Transfer

    Warehouse Transfer v2

    The version of the OpenAPI document: v2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from linnworks_api.generated.warehousetransfer_v2.models.transfer_status import TransferStatus
from linnworks_api.generated.warehousetransfer_v2.models.transfer_type import TransferType
from typing import Optional, Set
from typing_extensions import Self

class WarehouseTransferModel(BaseModel):
    """
    Transfer model
    """ # noqa: E501
    create_date: Optional[datetime] = Field(default=None, description="The date that transfer is created", alias="createDate")
    from_location_id: Optional[StrictStr] = Field(default=None, description="The location id that transfer is from", alias="fromLocationId")
    reference_number: Optional[StrictStr] = Field(default=None, description="Transfer unique reference number", alias="referenceNumber")
    status: Optional[TransferStatus] = None
    to_location_id: Optional[StrictStr] = Field(default=None, description="The location id that transfer is to", alias="toLocationId")
    transfer_id: Optional[StrictInt] = Field(default=None, description="Transfer unique id", alias="transferId")
    transfer_type: Optional[TransferType] = Field(default=None, alias="transferType")
    update_date: Optional[datetime] = Field(default=None, description="The date that transfer is last updated", alias="updateDate")
    __properties: ClassVar[List[str]] = ["createDate", "fromLocationId", "referenceNumber", "status", "toLocationId", "transferId", "transferType", "updateDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WarehouseTransferModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if reference_number (nullable) is None
        # and model_fields_set contains the field
        if self.reference_number is None and "reference_number" in self.model_fields_set:
            _dict['referenceNumber'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WarehouseTransferModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createDate": obj.get("createDate"),
            "fromLocationId": obj.get("fromLocationId"),
            "referenceNumber": obj.get("referenceNumber"),
            "status": obj.get("status"),
            "toLocationId": obj.get("toLocationId"),
            "transferId": obj.get("transferId"),
            "transferType": obj.get("transferType"),
            "updateDate": obj.get("updateDate")
        })
        return _obj


