from setuptools import setup, find_packages
import subprocess

git_command_result: subprocess.CompletedProcess = subprocess.run(
    ["git", "describe", "--tags"], capture_output=True, encoding="utf-8"
)
actual_version: str = git_command_result.stdout.strip("\n") or "1.0.1"

setup(
    name="LinuxServerStatsTelegramBot",
    version=actual_version,
    packages=find_packages(),
    url="",
    license="MIT",
    author="Juares Vermelho Diaz",
    author_email="j.vermelho@gmail.com",
    description="Telegram bot manager to show linux server stats",
    entry_points={
        "console_scripts": [
            "send_stats_by_telegram = LinuxServerStatsTelegramBot.cli:notify_server_stats",
            "start_bot = LinuxServerStatsTelegramBot.bot:main",
        ]
    },
    package_data={"": ["assets/*.webp"]},
    include_package_data=True,
    install_requires=[
        "anyio==4.9.0; python_version >= '3.9'",
        "backports.tarfile==1.2.0; python_version < '3.12'",
        "certifi==2025.6.15; python_version >= '3.7'",
        "cffi==1.17.1; platform_python_implementation != 'PyPy'",
        "charset-normalizer==3.4.2; python_version >= '3.7'",
        "click==8.1.8; python_version >= '3.7'",
        "croniter==6.0.0; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "cryptography==45.0.4; python_version >= '3.7' and python_full_version not in '3.9.0, 3.9.1'",
        "decorator==5.2.1; python_version >= '3.8'",
        "docutils==0.21.2; python_version >= '3.9'",
        "exceptiongroup==1.3.0; python_version < '3.11'",
        "future==1.0.0; python_version >= '2.6' and python_version not in '3.0, 3.1, 3.2'",
        "geocoder==1.38.1",
        "gps==3.19",
        "h11==0.16.0; python_version >= '3.8'",
        "httpcore==1.0.9; python_version >= '3.8'",
        "httpx==0.28.1; python_version >= '3.8'",
        "id==1.5.0; python_version >= '3.8'",
        "idna==3.10; python_version >= '3.6'",
        "importlib-metadata==8.7.0; python_version < '3.10'",
        "jaraco.classes==3.4.0; python_version >= '3.8'",
        "jaraco.context==6.0.1; python_version >= '3.8'",
        "jaraco.functools==4.2.1; python_version >= '3.9'",
        "jeepney==0.9.0; sys_platform == 'linux'",
        "keyring==25.6.0; platform_machine != 'ppc64le' and platform_machine != 's390x'",
        "markdown-it-py==3.0.0; python_version >= '3.8'",
        "mdurl==0.1.2; python_version >= '3.7'",
        "more-itertools==10.7.0; python_version >= '3.9'",
        "nh3==0.2.21; python_version >= '3.8'",
        "packaging==25.0; python_version >= '3.8'",
        "pillow==11.2.1; python_version >= '3.9'",
        "pycparser==2.22; python_version >= '3.8'",
        "pygments==2.19.2; python_version >= '3.8'",
        "python-crontab==3.2.0",
        "python-dateutil==2.9.0.post0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2'",
        "python-nmap==0.7.1",
        "python-telegram-bot==22.1; python_version >= '3.9'",
        "pytz==2025.2",
        "ratelim==0.1.6",
        "readme-renderer==44.0; python_version >= '3.9'",
        "requests==2.32.4; python_version >= '3.8'",
        "requests-toolbelt==1.0.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2, 3.3'",
        "rfc3986==2.0.0; python_version >= '3.7'",
        "rich==14.0.0; python_full_version >= '3.8.0'",
        "secretstorage==3.3.3; sys_platform == 'linux'",
        "setuptools==80.9.0; python_version >= '3.9'",
        "six==1.17.0; python_version >= '2.7' and python_version not in '3.0, 3.1, 3.2'",
        "sniffio==1.3.1; python_version >= '3.7'",
        "twine==6.1.0; python_version >= '3.8'",
        "typing-extensions==4.14.0; python_version < '3.11'",
        "urllib3==2.5.0; python_version >= '3.9'",
        "wheel==0.45.1; python_version >= '3.8'",
        "zipp==3.23.0; python_version >= '3.9'",
    ],
)
