# Converts a list of numpy arrays to a ndarray



```python  
$ pip install listarray2ndarray
from listarray2ndarray import print_alldtypes, convert_to_all_possible_dtypes, la_to_ndarray

# All dtypes
print_alldtypes() 

b  -  numpy.byte signed integer type, compatible with C char.
h  -  numpy.short Signed integer type, compatible with C short.
i  -  numpy.intc Signed integer type, compatible with C int.
l  -  numpy.int_ Signed integer type, compatible with Python int and C long.
q  -  class numpy.longlong Signed integer type, compatible with C long long.
B  -  numpy.ubyte Unsigned integer type, compatible with C unsigned char.
H  -  numpy.ushort Unsigned integer type, compatible with C unsigned short.
I  -  Unsigned integer type, compatible with C unsigned int.
L  -  Unsigned integer large enough to fit pointer, compatible with C uintptr_t.
Q  -  Signed integer type, compatible with C unsigned long long.
e  -  16-bit-precision floating-point number type: sign bit, 5 bits exponent, 10 bits mantissa.
f  -  32-bit-precision floating-point number type: sign bit, 8 bits exponent, 23 bits mantissa.
d  -  64-bit precision floating-point number type: sign bit, 11 bits exponent, 52 bits mantissa.
g  -  128-bit extended-precision floating-point number type.
F  -  Complex number type composed of 2 32-bit-precision floating-point numbers.
D  -  Complex number type composed of two double-precision floating-point numbers, compatible with Python complex.
G  -  Complex number type composed of 2 128-bit extended-precision floating-point numbers.
?  -  The bool_ type is not a subclass of the int_ type (the bool_ is not even a number type). This is different than Python’s default implementation of bool as a sub-class of int.
M  -  numpy.datetime64
m  -  A timedelta stored as a 64-bit integer.
O  -  Any Python object
S  -  When used in arrays, this type strips trailing null bytes.
U  -  Unlike the builtin str, this supports the Buffer Protocol, exposing its contents as UCS4:
V  -  Create a new structured or unstructured void scalar.


import numpy as np
with np.printoptions(threshold=10,linewidth=100,edgeitems=2):
    np.linspace(0, 10, 10)
    c = np.array(list(range(10000)))
    b = np.array(list(range(9800, 20000)))
    a = np.concatenate([c, b])
    print(a)
    bz = la_to_ndarray(a, continous_array=True, dtype=None)
    print(bz)
    print(bz.shape)
    cax = [cc.reshape((10, -1)) for cc in np.split(c, 10)]
    print(cax)
    bz = la_to_ndarray(cax, continous_array=True, dtype="e")
    print(bz)
    print(bz.shape)
    cax = [np.split(cc.reshape((10, -1)), 10) for cc in np.split(c, 10)]
    print(cax)
    bz = la_to_ndarray(cax, continous_array=True, dtype="i")
    print(bz)
    print(bz.shape)

    ax = np.array(list(range(1000)))
    adt = convert_to_all_possible_dtypes(
        ax,
        with_bit_variations=False,
        continous_array=True,
        ignore_dtypes=("M", "m", "O"),
        ignore_bit=(), # ignored because with_bit_variations is False
    )
    print(adt)
    adt2 = convert_to_all_possible_dtypes(
        ax,
        with_bit_variations=True,
        continous_array=True,
        ignore_dtypes=("M", "m", "O"),
        ignore_bit=(64, 128, 256),
    )
    print(adt2)
    cax = np.linspace(0, 100, 10000)
    print(cax)
    ra = la_to_ndarray(cax, continous_array=True, dtype="i4")
    print(ra)


[    0     1 ... 19998 19999]
[    0     1 ... 19998 19999]
(20200,)
[array([[  0,   1, ...,  98,  99],
       [100, 101, ..., 198, 199],
       ...,
       [800, 801, ..., 898, 899],
       [900, 901, ..., 998, 999]]), array([[1000, 1001, ..., 1098, 1099],
       [1100, 1101, ..., 1198, 1199],
       ...,
       [1800, 1801, ..., 1898, 1899],
       [1900, 1901, ..., 1998, 1999]]), array([[2000, 2001, ..., 2098, 2099],
       [2100, 2101, ..., 2198, 2199],
       ...,
       [2800, 2801, ..., 2898, 2899],
       [2900, 2901, ..., 2998, 2999]]), array([[3000, 3001, ..., 3098, 3099],
       [3100, 3101, ..., 3198, 3199],
       ...,
       [3800, 3801, ..., 3898, 3899],
       [3900, 3901, ..., 3998, 3999]]), array([[4000, 4001, ..., 4098, 4099],
       [4100, 4101, ..., 4198, 4199],
       ...,
       [4800, 4801, ..., 4898, 4899],
       [4900, 4901, ..., 4998, 4999]]), array([[5000, 5001, ..., 5098, 5099],
       [5100, 5101, ..., 5198, 5199],
       ...,
       [5800, 5801, ..., 5898, 5899],
       [5900, 5901, ..., 5998, 5999]]), array([[6000, 6001, ..., 6098, 6099],
       [6100, 6101, ..., 6198, 6199],
       ...,
       [6800, 6801, ..., 6898, 6899],
       [6900, 6901, ..., 6998, 6999]]), array([[7000, 7001, ..., 7098, 7099],
       [7100, 7101, ..., 7198, 7199],
       ...,
       [7800, 7801, ..., 7898, 7899],
       [7900, 7901, ..., 7998, 7999]]), array([[8000, 8001, ..., 8098, 8099],
       [8100, 8101, ..., 8198, 8199],
       ...,
       [8800, 8801, ..., 8898, 8899],
       [8900, 8901, ..., 8998, 8999]]), array([[9000, 9001, ..., 9098, 9099],
       [9100, 9101, ..., 9198, 9199],
       ...,
       [9800, 9801, ..., 9898, 9899],
       [9900, 9901, ..., 9998, 9999]])]
[[[0.000e+00 1.000e+03 ... 8.000e+03 9.000e+03]
  [1.000e+00 1.001e+03 ... 8.000e+03 9.000e+03]
  ...
  [9.800e+01 1.098e+03 ... 8.096e+03 9.096e+03]
  [9.900e+01 1.099e+03 ... 8.100e+03 9.096e+03]]
 [[1.000e+02 1.100e+03 ... 8.100e+03 9.104e+03]
  [1.010e+02 1.101e+03 ... 8.100e+03 9.104e+03]
  ...
  [1.980e+02 1.198e+03 ... 8.200e+03 9.200e+03]
  [1.990e+02 1.199e+03 ... 8.200e+03 9.200e+03]]
 ...
 [[8.000e+02 1.800e+03 ... 8.800e+03 9.800e+03]
  [8.010e+02 1.801e+03 ... 8.800e+03 9.800e+03]
  ...
  [8.980e+02 1.898e+03 ... 8.896e+03 9.896e+03]
  [8.990e+02 1.899e+03 ... 8.896e+03 9.896e+03]]
 [[9.000e+02 1.900e+03 ... 8.896e+03 9.904e+03]
  [9.010e+02 1.901e+03 ... 8.904e+03 9.904e+03]
  ...
  [9.980e+02 1.998e+03 ... 9.000e+03 1.000e+04]
  [9.990e+02 1.999e+03 ... 9.000e+03 1.000e+04]]]
(10, 100, 10)
[[array([[ 0,  1, ..., 98, 99]]), array([[100, 101, ..., 198, 199]]), array([[200, 201, ..., 298, 299]]), array([[300, 301, ..., 398, 399]]), array([[400, 401, ..., 498, 499]]), array([[500, 501, ..., 598, 599]]), array([[600, 601, ..., 698, 699]]), array([[700, 701, ..., 798, 799]]), array([[800, 801, ..., 898, 899]]), array([[900, 901, ..., 998, 999]])], [array([[1000, 1001, ..., 1098, 1099]]), array([[1100, 1101, ..., 1198, 1199]]), array([[1200, 1201, ..., 1298, 1299]]), array([[1300, 1301, ..., 1398, 1399]]), array([[1400, 1401, ..., 1498, 1499]]), array([[1500, 1501, ..., 1598, 1599]]), array([[1600, 1601, ..., 1698, 1699]]), array([[1700, 1701, ..., 1798, 1799]]), array([[1800, 1801, ..., 1898, 1899]]), array([[1900, 1901, ..., 1998, 1999]])], [array([[2000, 2001, ..., 2098, 2099]]), array([[2100, 2101, ..., 2198, 2199]]), array([[2200, 2201, ..., 2298, 2299]]), array([[2300, 2301, ..., 2398, 2399]]), array([[2400, 2401, ..., 2498, 2499]]), array([[2500, 2501, ..., 2598, 2599]]), array([[2600, 2601, ..., 2698, 2699]]), array([[2700, 2701, ..., 2798, 2799]]), array([[2800, 2801, ..., 2898, 2899]]), array([[2900, 2901, ..., 2998, 2999]])], [array([[3000, 3001, ..., 3098, 3099]]), array([[3100, 3101, ..., 3198, 3199]]), array([[3200, 3201, ..., 3298, 3299]]), array([[3300, 3301, ..., 3398, 3399]]), array([[3400, 3401, ..., 3498, 3499]]), array([[3500, 3501, ..., 3598, 3599]]), array([[3600, 3601, ..., 3698, 3699]]), array([[3700, 3701, ..., 3798, 3799]]), array([[3800, 3801, ..., 3898, 3899]]), array([[3900, 3901, ..., 3998, 3999]])], [array([[4000, 4001, ..., 4098, 4099]]), array([[4100, 4101, ..., 4198, 4199]]), array([[4200, 4201, ..., 4298, 4299]]), array([[4300, 4301, ..., 4398, 4399]]), array([[4400, 4401, ..., 4498, 4499]]), array([[4500, 4501, ..., 4598, 4599]]), array([[4600, 4601, ..., 4698, 4699]]), array([[4700, 4701, ..., 4798, 4799]]), array([[4800, 4801, ..., 4898, 4899]]), array([[4900, 4901, ..., 4998, 4999]])], [array([[5000, 5001, ..., 5098, 5099]]), array([[5100, 5101, ..., 5198, 5199]]), array([[5200, 5201, ..., 5298, 5299]]), array([[5300, 5301, ..., 5398, 5399]]), array([[5400, 5401, ..., 5498, 5499]]), array([[5500, 5501, ..., 5598, 5599]]), array([[5600, 5601, ..., 5698, 5699]]), array([[5700, 5701, ..., 5798, 5799]]), array([[5800, 5801, ..., 5898, 5899]]), array([[5900, 5901, ..., 5998, 5999]])], [array([[6000, 6001, ..., 6098, 6099]]), array([[6100, 6101, ..., 6198, 6199]]), array([[6200, 6201, ..., 6298, 6299]]), array([[6300, 6301, ..., 6398, 6399]]), array([[6400, 6401, ..., 6498, 6499]]), array([[6500, 6501, ..., 6598, 6599]]), array([[6600, 6601, ..., 6698, 6699]]), array([[6700, 6701, ..., 6798, 6799]]), array([[6800, 6801, ..., 6898, 6899]]), array([[6900, 6901, ..., 6998, 6999]])], [array([[7000, 7001, ..., 7098, 7099]]), array([[7100, 7101, ..., 7198, 7199]]), array([[7200, 7201, ..., 7298, 7299]]), array([[7300, 7301, ..., 7398, 7399]]), array([[7400, 7401, ..., 7498, 7499]]), array([[7500, 7501, ..., 7598, 7599]]), array([[7600, 7601, ..., 7698, 7699]]), array([[7700, 7701, ..., 7798, 7799]]), array([[7800, 7801, ..., 7898, 7899]]), array([[7900, 7901, ..., 7998, 7999]])], [array([[8000, 8001, ..., 8098, 8099]]), array([[8100, 8101, ..., 8198, 8199]]), array([[8200, 8201, ..., 8298, 8299]]), array([[8300, 8301, ..., 8398, 8399]]), array([[8400, 8401, ..., 8498, 8499]]), array([[8500, 8501, ..., 8598, 8599]]), array([[8600, 8601, ..., 8698, 8699]]), array([[8700, 8701, ..., 8798, 8799]]), array([[8800, 8801, ..., 8898, 8899]]), array([[8900, 8901, ..., 8998, 8999]])], [array([[9000, 9001, ..., 9098, 9099]]), array([[9100, 9101, ..., 9198, 9199]]), array([[9200, 9201, ..., 9298, 9299]]), array([[9300, 9301, ..., 9398, 9399]]), array([[9400, 9401, ..., 9498, 9499]]), array([[9500, 9501, ..., 9598, 9599]]), array([[9600, 9601, ..., 9698, 9699]]), array([[9700, 9701, ..., 9798, 9799]]), array([[9800, 9801, ..., 9898, 9899]]), array([[9900, 9901, ..., 9998, 9999]])]]
[[[[   0 1000 ... 8000 9000]
   [   1 1001 ... 8001 9001]
   ...
   [  98 1098 ... 8098 9098]
   [  99 1099 ... 8099 9099]]]
 [[[ 100 1100 ... 8100 9100]
   [ 101 1101 ... 8101 9101]
   ...
   [ 198 1198 ... 8198 9198]
   [ 199 1199 ... 8199 9199]]]
 ...
 [[[ 800 1800 ... 8800 9800]
   [ 801 1801 ... 8801 9801]
   ...
   [ 898 1898 ... 8898 9898]
   [ 899 1899 ... 8899 9899]]]
 [[[ 900 1900 ... 8900 9900]
   [ 901 1901 ... 8901 9901]
   ...
   [ 998 1998 ... 8998 9998]
   [ 999 1999 ... 8999 9999]]]]
(10, 1, 100, 10)
{'b': array([[[  0,   1, ..., -26, -25]]], dtype=int8), 'h': array([[[  0,   1, ..., 998, 999]]], dtype=int16), 'i': array([  0,   1, ..., 998, 999], dtype=int32), 'l': array([  0,   1, ..., 998, 999]), 'q': array([[[  0,   1, ..., 998, 999]]], dtype=int64), 'B': array([[[  0,   1, ..., 230, 231]]], dtype=uint8), 'H': array([[[  0,   1, ..., 998, 999]]], dtype=uint16), 'I': array([  0,   1, ..., 998, 999], dtype=uint32), 'L': array([  0,   1, ..., 998, 999], dtype=uint32), 'Q': array([[[  0,   1, ..., 998, 999]]], dtype=uint64), 'e': array([[[  0.,   1., ..., 998., 999.]]], dtype=float16), 'f': array([0.000e+00, 1.401e-45, ..., 1.398e-42, 1.400e-42], dtype=float32), 'd': array([[[  0.,   1., ..., 998., 999.]]]), 'g': array([[[  0.,   1., ..., 998., 999.]]], dtype=float64), 'F': array([[[  0.+0.j,   1.+0.j, ..., 998.+0.j, 999.+0.j]]], dtype=complex64), 'D': array([[[  0.+0.j,   1.+0.j, ..., 998.+0.j, 999.+0.j]]]), 'G': array([[[  0.+0.j,   1.+0.j, ..., 998.+0.j, 999.+0.j]]], dtype=complex128), '?': array([[[False,  True, ...,  True,  True]]]), 'S': array([[[b'0', b'1', ..., b'998', b'999']]], dtype='|S11'), 'U': array(['\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0¡¢£¤¥¦§¨©ª«¬\xad®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿĀāĂăĄąĆćĈĉĊċČčĎďĐđĒēĔĕĖėĘęĚěĜĝĞğĠġĢģĤĥĦħĨĩĪīĬĭĮįİıĲĳĴĵĶķĸĹĺĻļĽľĿŀŁłŃńŅņŇňŉŊŋŌōŎŏŐőŒœŔŕŖŗŘřŚśŜŝŞşŠšŢţŤťŦŧŨũŪūŬŭŮůŰűŲųŴŵŶŷŸŹźŻżŽžſƀƁƂƃƄƅƆƇƈƉƊƋƌƍƎƏƐƑƒƓƔƕƖƗƘƙƚƛƜƝƞƟƠơƢƣƤƥƦƧƨƩƪƫƬƭƮƯưƱƲƳƴƵƶƷƸƹƺƻƼƽƾƿǀǁǂǃǄǅǆǇǈǉǊǋǌǍǎǏǐǑǒǓǔǕǖǗǘǙǚǛǜǝǞǟǠǡǢǣǤǥǦǧǨǩǪǫǬǭǮǯǰǱǲǳǴǵǶǷǸǹǺǻǼǽǾǿȀȁȂȃȄȅȆȇȈȉȊȋȌȍȎȏȐȑȒȓȔȕȖȗȘșȚțȜȝȞȟȠȡȢȣȤȥȦȧȨȩȪȫȬȭȮȯȰȱȲȳȴȵȶȷȸȹȺȻȼȽȾȿɀɁɂɃɄɅɆɇɈɉɊɋɌɍɎɏɐɑɒɓɔɕɖɗɘəɚɛɜɝɞɟɠɡɢɣɤɥɦɧɨɩɪɫɬɭɮɯɰɱɲɳɴɵɶɷɸɹɺɻɼɽɾɿʀʁʂʃʄʅʆʇʈʉʊʋʌʍʎʏʐʑʒʓʔʕʖʗʘʙʚʛʜʝʞʟʠʡʢʣʤʥʦʧʨʩʪʫʬʭʮʯʰʱʲʳʴʵʶʷʸʹʺʻʼʽʾʿˀˁ˂˃˄˅ˆˇˈˉˊˋˌˍˎˏːˑ˒˓˔˕˖˗˘˙˚˛˜˝˞˟ˠˡˢˣˤ˥˦˧˨˩˪˫ˬ˭ˮ˯˰˱˲˳˴˵˶˷˸˹˺˻˼˽˾˿̴̵̶̷̸̡̢̧̨̛̖̗̘̙̜̝̞̟̠̣̤̥̦̩̪̫̬̭̮̯̰̱̲̳̹̺̻̼͇͈͉͍͎̀́̂̃̄̅̆̇̈̉̊̋̌̍̎̏̐̑̒̓̔̽̾̿̀́͂̓̈́͆͊͋͌̕̚ͅ͏͓͔͕͖͙͚͐͑͒͗͛ͣͤͥͦͧͨͩͪͫͬͭͮͯ͘͜͟͢͝͞͠͡ͰͱͲͳʹ͵Ͷͷ\u0378\u0379ͺͻͼͽ;Ϳ\u0380\u0381\u0382\u0383΄΅Ά·ΈΉΊ\u038bΌ\u038dΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ\u03a2ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώϏϐϑϒϓϔϕϖϗϘϙϚϛϜϝϞϟϠϡϢϣϤϥϦϧ'],
      dtype='<U1000'), 'V': array([[[b'\x00\x00\x00\x00', b'\x01\x00\x00\x00', ..., b'\xE6\x03\x00\x00', b'\xE7\x03\x00\x00']]],
      dtype='|V4')}
{'b': array([[[  0,   1, ..., -26, -25]]], dtype=int8), 'h': array([[[  0,   1, ..., 998, 999]]], dtype=int16), 'i': array([  0,   1, ..., 998, 999], dtype=int32), 'i8': array([[[  0,   1, ..., 998, 999]]], dtype=int64), 'l': array([  0,   1, ..., 998, 999]), 'q': array([[[  0,   1, ..., 998, 999]]], dtype=int64), 'B': array([[[  0,   1, ..., 230, 231]]], dtype=uint8), 'H': array([[[  0,   1, ..., 998, 999]]], dtype=uint16), 'I': array([  0,   1, ..., 998, 999], dtype=uint32), 'L': array([  0,   1, ..., 998, 999], dtype=uint32), 'Q': array([[[  0,   1, ..., 998, 999]]], dtype=uint64), 'e': array([[[  0.,   1., ..., 998., 999.]]], dtype=float16), 'f': array([0.000e+00, 1.401e-45, ..., 1.398e-42, 1.400e-42], dtype=float32), 'f8': array([[[  0.,   1., ..., 998., 999.]]]), 'd': array([[[  0.,   1., ..., 998., 999.]]]), 'g': array([[[  0.,   1., ..., 998., 999.]]], dtype=float64), 'F': array([[[  0.+0.j,   1.+0.j, ..., 998.+0.j, 999.+0.j]]], dtype=complex64), 'D': array([[[  0.+0.j,   1.+0.j, ..., 998.+0.j, 999.+0.j]]]), 'G': array([[[  0.+0.j,   1.+0.j, ..., 998.+0.j, 999.+0.j]]], dtype=complex128), '?': array([[[False,  True, ...,  True,  True]]]), 'S': array([[[b'0', b'1', ..., b'998', b'999']]], dtype='|S11'), 'S8': array([[[b'0', b'1', ..., b'998', b'999']]], dtype='|S8'), 'S16': array([[[b'0', b'1', ..., b'998', b'999']]], dtype='|S16'), 'S32': array([[[b'0', b'1', ..., b'998', b'999']]], dtype='|S32'), 'U': array(['\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0¡¢£¤¥¦§¨©ª«¬\xad®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿĀāĂăĄąĆćĈĉĊċČčĎďĐđĒēĔĕĖėĘęĚěĜĝĞğĠġĢģĤĥĦħĨĩĪīĬĭĮįİıĲĳĴĵĶķĸĹĺĻļĽľĿŀŁłŃńŅņŇňŉŊŋŌōŎŏŐőŒœŔŕŖŗŘřŚśŜŝŞşŠšŢţŤťŦŧŨũŪūŬŭŮůŰűŲųŴŵŶŷŸŹźŻżŽžſƀƁƂƃƄƅƆƇƈƉƊƋƌƍƎƏƐƑƒƓƔƕƖƗƘƙƚƛƜƝƞƟƠơƢƣƤƥƦƧƨƩƪƫƬƭƮƯưƱƲƳƴƵƶƷƸƹƺƻƼƽƾƿǀǁǂǃǄǅǆǇǈǉǊǋǌǍǎǏǐǑǒǓǔǕǖǗǘǙǚǛǜǝǞǟǠǡǢǣǤǥǦǧǨǩǪǫǬǭǮǯǰǱǲǳǴǵǶǷǸǹǺǻǼǽǾǿȀȁȂȃȄȅȆȇȈȉȊȋȌȍȎȏȐȑȒȓȔȕȖȗȘșȚțȜȝȞȟȠȡȢȣȤȥȦȧȨȩȪȫȬȭȮȯȰȱȲȳȴȵȶȷȸȹȺȻȼȽȾȿɀɁɂɃɄɅɆɇɈɉɊɋɌɍɎɏɐɑɒɓɔɕɖɗɘəɚɛɜɝɞɟɠɡɢɣɤɥɦɧɨɩɪɫɬɭɮɯɰɱɲɳɴɵɶɷɸɹɺɻɼɽɾɿʀʁʂʃʄʅʆʇʈʉʊʋʌʍʎʏʐʑʒʓʔʕʖʗʘʙʚʛʜʝʞʟʠʡʢʣʤʥʦʧʨʩʪʫʬʭʮʯʰʱʲʳʴʵʶʷʸʹʺʻʼʽʾʿˀˁ˂˃˄˅ˆˇˈˉˊˋˌˍˎˏːˑ˒˓˔˕˖˗˘˙˚˛˜˝˞˟ˠˡˢˣˤ˥˦˧˨˩˪˫ˬ˭ˮ˯˰˱˲˳˴˵˶˷˸˹˺˻˼˽˾˿̴̵̶̷̸̡̢̧̨̛̖̗̘̙̜̝̞̟̠̣̤̥̦̩̪̫̬̭̮̯̰̱̲̳̹̺̻̼͇͈͉͍͎̀́̂̃̄̅̆̇̈̉̊̋̌̍̎̏̐̑̒̓̔̽̾̿̀́͂̓̈́͆͊͋͌̕̚ͅ͏͓͔͕͖͙͚͐͑͒͗͛ͣͤͥͦͧͨͩͪͫͬͭͮͯ͘͜͟͢͝͞͠͡ͰͱͲͳʹ͵Ͷͷ\u0378\u0379ͺͻͼͽ;Ϳ\u0380\u0381\u0382\u0383΄΅Ά·ΈΉΊ\u038bΌ\u038dΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡ\u03a2ΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώϏϐϑϒϓϔϕϖϗϘϙϚϛϜϝϞϟϠϡϢϣϤϥϦϧ'],
      dtype='<U1000'), 'U8': array([[['0', '1', ..., '998', '999']]], dtype='<U8'), 'U16': array([[['0', '1', ..., '998', '999']]], dtype='<U16'), 'U32': array([[['0', '1', ..., '998', '999']]], dtype='<U32'), 'V': array([[[b'\x00\x00\x00\x00', b'\x01\x00\x00\x00', ..., b'\xE6\x03\x00\x00', b'\xE7\x03\x00\x00']]],
      dtype='|V4'), 'V8': array([[[b'\x00\x00\x00\x00\x00\x00\x00\x00', b'\x01\x00\x00\x00\x00\x00\x00\x00', ...,
         b'\xE6\x03\x00\x00\x00\x00\x00\x00', b'\xE7\x03\x00\x00\x00\x00\x00\x00']]], dtype='|V8'), 'V16': array([[[b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
         b'\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00', ...,
         b'\xE6\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
         b'\xE7\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00']]], dtype='|V16'), 'V32': array([[[b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
         b'\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
         ...,
         b'\xE6\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00',
         b'\xE7\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00']]],
      dtype='|V32')}
[0.00000000e+00 1.00010001e-02 ... 9.99899990e+01 1.00000000e+02]
[[[  0   0 ...  99 100]]]





```