set(LLAMA_VERSION 0.0.1)
set(LLAMA_BUILD_COMMIT 75cd4c7)
set(LLAMA_BUILD_NUMBER 1)
set(LLAMA_SHARED_LIB On)
set(LLAMA_BLAS OFF)
set(LLAMA_CUDA OFF)
set(LLAMA_METAL off)
set(LLAMA_MPI OFF)
set(LLAMA_CLBLAST OFF)
set(LLAMA_HIPBLAS OFF)
set(LLAMA_ACCELERATE ON)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was LlamaConfig.cmake.in                            ########

get_filename_component(PACKAGE_${CMAKE_FIND_PACKAGE_NAME}_COUNTER_1 "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(LLAMA_INCLUDE_DIR "${PACKAGE_${CMAKE_FIND_PACKAGE_NAME}_COUNTER_1}/include")
set_and_check(LLAMA_LIB_DIR "${PACKAGE_${CMAKE_FIND_PACKAGE_NAME}_COUNTER_1}/lib")
set_and_check(LLAMA_BIN_DIR "${PACKAGE_${CMAKE_FIND_PACKAGE_NAME}_COUNTER_1}/bin")

# Ensure transient dependencies satisfied

find_package(Threads REQUIRED)
if (APPLE AND LLAMA_ACCELERATE)
    find_library(ACCELERATE_FRAMEWORK Accelerate REQUIRED)
endif()

if (LLAMA_BLAS)
    find_package(BLAS REQUIRED)
endif()

if (LLAMA_CUDA)
    find_package(CUDAToolkit REQUIRED)
endif()

if (LLAMA_METAL)
    find_library(FOUNDATION_LIBRARY Foundation REQUIRED)
    find_library(METAL_FRAMEWORK Metal REQUIRED)
    find_library(METALKIT_FRAMEWORK MetalKit REQUIRED)
endif()

if (LLAMA_MPI)
    find_package(MPI REQUIRED)
endif()

if (LLAMA_CLBLAST)
    find_package(CLBlast REQUIRED)
endif()

if (LLAMA_HIPBLAS)
    find_package(hip REQUIRED)
    find_package(hipblas REQUIRED)
    find_package(rocblas REQUIRED)
endif()

find_library(llama_LIBRARY llama
    REQUIRED
    HINTS ${LLAMA_LIB_DIR})

set(_llama_link_deps "Threads::Threads" "/Applications/Xcode_15.0.1.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX14.0.sdk/System/Library/Frameworks/Accelerate.framework")
set(_llama_transient_defines "GGML_SCHED_MAX_COPIES=4;GGML_USE_ACCELERATE;ACCELERATE_NEW_LAPACK;ACCELERATE_LAPACK_ILP64;HAVE_BUGGY_APPLE_LINKER;_XOPEN_SOURCE=600;_DARWIN_C_SOURCE")
add_library(llama UNKNOWN IMPORTED)
set_target_properties(llama
    PROPERTIES
        INTERFACE_INCLUDE_DIRECTORIES "${LLAMA_INCLUDE_DIR}"
        INTERFACE_LINK_LIBRARIES "${_llama_link_deps}"
        INTERFACE_COMPILE_DEFINITIONS "${_llama_transient_defines}"
        IMPORTED_LINK_INTERFACE_LANGUAGES "CXX"
        IMPORTED_LOCATION "${llama_LIBRARY}"
        INTERFACE_COMPILE_FEATURES cxx_std_11
        POSITION_INDEPENDENT_CODE ON )

check_required_components(Llama)
