# Lloyd-Python (0.1.1)

A modular command-line tool for terminal automation, file management, and custom math.

## Installation
If you are developing locally:
\`\`\`bash
pip install -e .
\`\`\`

## Commands & Syntax
Lloyd uses a specific syntax: `lloyd {command} {argument}`.

### 1. System & Info
* **info**: Lists all available words. 
  * Usage: `lloyd info`
* **ex / execute**: Runs a standard terminal command.
  * Usage: `lloyd ex {ls -la}`

### 2. Math & Memory (Core 2)
* **ma / math**: Solves math or stores values in memory. Supports `+`, `-`, `×`, `÷`, `%`.
  * Store a value: `lloyd ma {credits = 500}`
  * Solve with variables: `lloyd ma {credits * 2}`
  * Standard math: `lloyd ma {10 * 5}`

### 3. File Management
* **sea / search**: Lists files in a path.
  * Usage: `lloyd sea {tgt}` or `lloyd sea {/sdcard}`
* **dl / download**: Copies a file into the project `tgt` folder.
  * Usage: `lloyd dl {/path/to/file}`
* **ac / access**: Reads the text content of a file inside `tgt`.
  * Usage: `lloyd ac {notes.txt}`
* **name / rename**: Renames a file inside the `tgt` folder.
  * Usage: `lloyd name {old.txt > new.txt}`

### 4. Maintenance
* **bk / backup**: Triggers the tmux-resurrect backup script.
  * Usage: `lloyd bk`

## Directory Structure
- `src/lloyd/core1.py`: Command Manager.
- `src/lloyd/core2.py`: Math & Memory Specialist.
- `tgt/`: Default target folder for downloads and renames.
