"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from lob_python.exceptions import ApiAttributeError

from lob_python.model.card_id import CardId
from lob_python.model.mail_type import MailType
from lob_python.model.merge_variables import MergeVariables
from lob_python.model.metadata_model import MetadataModel
from lob_python.model.resource_description import ResourceDescription
globals()['CardId'] = CardId
globals()['MailType'] = MailType
globals()['MergeVariables'] = MergeVariables
globals()['MetadataModel'] = MetadataModel
globals()['ResourceDescription'] = ResourceDescription


class LetterEditable(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('address_placement',): {
            'TOP_FIRST_PAGE': "top_first_page",
            'INSERT_BLANK_PAGE': "insert_blank_page",
            'BOTTOM_FIRST_PAGE_CENTER': "bottom_first_page_center",
            'BOTTOM_FIRST_PAGE': "bottom_first_page",
        },
        ('extra_service',): {
            'None': None,
            'CERTIFIED': "certified",
            'CERTIFIED_RETURN_RECEIPT': "certified_return_receipt",
            'REGISTERED': "registered",
            'NULL': "null",
        },
    }

    validations = {
        ('cards',): {
            'max_items': 1,
            'min_items': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        from lob_python.model.address_editable import AddressEditable
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'color': (bool,),  # noqa: E501
            'to': (str, AddressEditable),  # noqa: E501
            '_from': (str, AddressEditable),  # noqa: E501
            'file': (str,),  # noqa: E501
            'description': (str, type(None)),  # noqa: E501
            'metadata': (MetadataModel, type(None)),  # noqa: E501
            'mail_type': (MailType, type(None)),  # noqa: E501
            'merge_variables': (MergeVariables, type(None)),  # noqa: E501
            'send_date': (datetime, type(None)),  # noqa: E501
            'double_sided': (bool, type(None)),  # noqa: E501
            'address_placement': (str, type(None)),  # noqa: E501
            'return_envelope': (str, bool, type(None)),  # noqa: E501
            'perforated_page': (int, type(None)),  # noqa: E501
            'custom_envelope': (str, type(None)),  # noqa: E501
            'extra_service': (str, type(None)),  # noqa: E501
            'cards': (list, type(None)),  # noqa: E501
            'billing_group_id': (str, type(None)),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'color': 'color',  # noqa: E501
        'to': 'to',  # noqa: E501
        '_from': 'from',  # noqa: E501
        'file': 'file',  # noqa: E501
        'description': 'description',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'mail_type': 'mail_type',  # noqa: E501
        'merge_variables': 'merge_variables',  # noqa: E501
        'send_date': 'send_date',  # noqa: E501
        'double_sided': 'double_sided',  # noqa: E501
        'address_placement': 'address_placement',  # noqa: E501
        'return_envelope': 'return_envelope',  # noqa: E501
        'perforated_page': 'perforated_page',  # noqa: E501
        'custom_envelope': 'custom_envelope',  # noqa: E501
        'extra_service': 'extra_service',  # noqa: E501
        'cards': 'cards',  # noqa: E501
        'billing_group_id': 'billing_group_id',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, color, to, _from, file, *args, **kwargs):  # noqa: E501
        """LetterEditable - a model defined in OpenAPI

        Args:
            color (bool): Set this key to `true` if you would like to print in color. Set to `false` if you would like to print in black and white.
            to (str, AddressEditable): Must either be an address ID or an inline object with correct address parameters..
            _from (str, AddressEditable): Must either be an address ID or an inline object with correct address parameters..
            file (str): PDF file containing the letter's formatting.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str, type(None)): [optional] # noqa: E501
            metadata (MetadataModel, type(None)): [optional] # noqa: E501
            mail_type (MailType, type(None)): [optional] # noqa: E501
            merge_variables (MergeVariables, type(None)): [optional] # noqa: E501
            send_date (datetime, type(None)): A timestamp in ISO 8601 format which specifies a date after the current time and up to 180 days in the future to send the letter off for production. Setting a send date overrides the default [cancellation window](#section/Cancellation-Windows) applied to the mailpiece. Until the `send_date` has passed, the mailpiece can be canceled. If a date in the format `2017-11-01` is passed, it will evaluate to midnight UTC of that date (`2017-11-01T00:00:00.000Z`). If a datetime is passed, that exact time will be used. A `send_date` passed with no time zone will default to UTC, while a `send_date` passed with a time zone will be converted to UTC.. [optional] # noqa: E501
            double_sided (bool, type(None)): Set this attribute to `true` for double sided printing, or `false` for for single sided printing. Defaults to `true`.. [optional] if omitted the server will use the default value of True # noqa: E501
            address_placement (str, type(None)): Specifies the location of the address information that will show through the double-window envelope. To see how this will impact your letter design, view our letter template.   * `top_first_page` - (default) print address information at the top of your provided first page   * `insert_blank_page` - insert a blank address page at the beginning of your file (you will be charged for the extra page)   * `bottom_first_page_center` - **(deprecation planned within a few months)** print address information at the bottom center of your provided first page   * `bottom_first_page` - print address information at the bottom of your provided first page . [optional] if omitted the server will use the default value of "top_first_page" # noqa: E501
            return_envelope (str, bool, type(None)): indicates if a return envelope is requested for the letter. The value corresponding to this field is by default a boolean. But if the account is signed up for custom return envelopes, the value is of type string and is `no_9_single_window` for a standard return envelope and a custom `return_envelope_id` for non-standard return envelopes.  To include a return envelope with your letter, set to `true` and specify the `perforated_page`. See [pricing](https://www.lob.com/pricing/print-mail#compare) for extra costs incurred.. [optional]  # noqa: E501
            perforated_page (int, type(None)): Required if `return_envelope` is `true`. The number of the page that should be perforated for use with the return envelope. Must be greater than or equal to `1`. The blank page added by `address_placement=insert_blank_page` will be ignored when considering the perforated page number. To see how perforation will impact your letter design, view our [perforation guide](https://s3-us-west-2.amazonaws.com/public.lob.com/assets/templates/letter_perf_template.pdf).. [optional] # noqa: E501
            custom_envelope (str, type(None)): [optional] # noqa: E501
            extra_service (str, type(None)): Add an extra service to your letter:   * `certified` - track and confirm delivery for domestic destinations. An extra sheet (1 PDF page single-sided or 2 PDF pages double-sided) is added to the beginning of your letter for address and barcode information. See here for templates: [#10 envelope](https://s3-us-west-2.amazonaws.com/public.lob.com/assets/templates/letter_certified_template.pdf) and [flat envelope](https://s3-us-west-2.amazonaws.com/public.lob.com/assets/templates/letter_certified_flat_template.pdf) (used for letters over 6 pages single-sided or 12 pages double-sided). You will not be charged for this extra sheet.   * `certified_return_receipt` - request an electronic copy of the recipient's signature to prove delivery of your certified letter   * `registered` - provides tracking and confirmation for international addresses . [optional] # noqa: E501
            cards (list, type(None)): A single-element array containing an existing card id in a string format. See [cards](#tag/Cards) for more information.. [optional] # noqa: E501
            billing_group_id (str, type(None)): An optional string with the billing group ID to tag your usage with. Is used for billing purposes. Requires special activation to use. See [Billing Group API](https://lob.github.io/lob-openapi/#tag/Billing-Groups) for more information.. [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.color = color
        self.to = to
        self._from = _from
        self.file = file
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, color, to, _from, file, *args, **kwargs):  # noqa: E501
        """LetterEditable - a model defined in OpenAPI

        Args:
            color (bool): Set this key to `true` if you would like to print in color. Set to `false` if you would like to print in black and white.
            to (str): Must either be an address ID or an inline object with correct address parameters.
            _from (str): Must either be an address ID or an inline object with correct address parameters.
            file (str): PDF file containing the letter's formatting.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            description (str, type(None)): [optional] # noqa: E501
            metadata (MetadataModel, type(None)): [optional] # noqa: E501
            mail_type (MailType, type(None)): [optional] # noqa: E501
            merge_variables (MergeVariables, type(None)): [optional] # noqa: E501
            send_date (datetime, type(None)): A timestamp in ISO 8601 format which specifies a date after the current time and up to 180 days in the future to send the letter off for production. Setting a send date overrides the default [cancellation window](#section/Cancellation-Windows) applied to the mailpiece. Until the `send_date` has passed, the mailpiece can be canceled. If a date in the format `2017-11-01` is passed, it will evaluate to midnight UTC of that date (`2017-11-01T00:00:00.000Z`). If a datetime is passed, that exact time will be used. A `send_date` passed with no time zone will default to UTC, while a `send_date` passed with a time zone will be converted to UTC.. [optional] # noqa: E501
            double_sided (bool, type(None)): Set this attribute to `true` for double sided printing, or `false` for for single sided printing. Defaults to `true`.. [optional] if omitted the server will use the default value of True # noqa: E501
            address_placement (str, type(None)): Specifies the location of the address information that will show through the double-window envelope. To see how this will impact your letter design, view our letter template.   * `top_first_page` - (default) print address information at the top of your provided first page   * `insert_blank_page` - insert a blank address page at the beginning of your file (you will be charged for the extra page)   * `bottom_first_page_center` - **(deprecation planned within a few months)** print address information at the bottom center of your provided first page   * `bottom_first_page` - print address information at the bottom of your provided first page . [optional] if omitted the server will use the default value of "top_first_page" # noqa: E501
            return_envelope (str, bool, type(None)): indicates if a return envelope is requested for the letter. The value corresponding to this field is by default a boolean. But if the account is signed up for custom return envelopes, the value is of type string and is `no_9_single_window` for a standard return envelope and a custom `return_envelope_id` for non-standard return envelopes.  To include a return envelope with your letter, set to `true` and specify the `perforated_page`. See [pricing](https://www.lob.com/pricing/print-mail#compare) for extra costs incurred.. [optional]  # noqa: E501
            perforated_page (int, type(None)): Required if `return_envelope` is `true`. The number of the page that should be perforated for use with the return envelope. Must be greater than or equal to `1`. The blank page added by `address_placement=insert_blank_page` will be ignored when considering the perforated page number. To see how perforation will impact your letter design, view our [perforation guide](https://s3-us-west-2.amazonaws.com/public.lob.com/assets/templates/letter_perf_template.pdf).. [optional] # noqa: E501
            custom_envelope (str, type(None)): [optional] # noqa: E501
            extra_service (str, type(None)): Add an extra service to your letter:   * `certified` - track and confirm delivery for domestic destinations. An extra sheet (1 PDF page single-sided or 2 PDF pages double-sided) is added to the beginning of your letter for address and barcode information. See here for templates: [#10 envelope](https://s3-us-west-2.amazonaws.com/public.lob.com/assets/templates/letter_certified_template.pdf) and [flat envelope](https://s3-us-west-2.amazonaws.com/public.lob.com/assets/templates/letter_certified_flat_template.pdf) (used for letters over 6 pages single-sided or 12 pages double-sided). You will not be charged for this extra sheet.   * `certified_return_receipt` - request an electronic copy of the recipient's signature to prove delivery of your certified letter   * `registered` - provides tracking and confirmation for international addresses . [optional] # noqa: E501
            cards (list, type(None)): A single-element array containing an existing card id in a string format. See [cards](#tag/Cards) for more information.. [optional] # noqa: E501
            billing_group_id (str, type(None)): An optional string with the billing group ID to tag your usage with. Is used for billing purposes. Requires special activation to use. See [Billing Group API](https://lob.github.io/lob-openapi/#tag/Billing-Groups) for more information.. [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.color = color
        self.to = to
        self._from = _from
        self.file = file
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
