"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from lob_python.exceptions import ApiAttributeError



class LobError(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status_code',): {
            '401': 401,
            '403': 403,
            '404': 404,
            '413': 413,
            '422': 422,
            '429': 429,
            '500': 500,
        },
        ('code',): {
            'BAD_REQUEST': "bad_request",
            'CONFLICT': "conflict",
            'FEATURE_LIMIT_REACHED': "feature_limit_reached",
            'INTERNAL_SERVER_ERROR': "internal_server_error",
            'INVALID': "invalid",
            'NOT_DELETABLE': "not_deletable",
            'NOT_FOUND': "not_found",
            'REQUEST_TIMEOUT': "request_timeout",
            'SERVICE_UNAVAILABLE': "service_unavailable",
            'UNRECOGNIZED_ENDPOINT': "unrecognized_endpoint",
            'UNSUPPORTED_LOB_VERSION': "unsupported_lob_version",
            'ADDRESS_LENGTH_EXCEEDS_LIMIT': "address_length_exceeds_limit",
            'BANK_ACCOUNT_ALREADY_VERIFIED': "bank_account_already_verified",
            'BANK_ERROR': "bank_error",
            'CUSTOM_ENVELOPE_INVENTORY_DEPLETED': "custom_envelope_inventory_depleted",
            'DELETED_BANK_ACCOUNT': "deleted_bank_account",
            'FAILED_DELIVERABILITY_STRICTNESS': "failed_deliverability_strictness",
            'FILE_PAGES_BELOW_MIN': "file_pages_below_min",
            'FILE_PAGES_EXCEED_MAX': "file_pages_exceed_max",
            'FILE_SIZE_EXCEEDS_LIMIT': "file_size_exceeds_limit",
            'FOREIGN_RETURN_ADDRESS': "foreign_return_address",
            'INCONSISTENT_PAGE_DIMENSIONS': "inconsistent_page_dimensions",
            'INVALID_BANK_ACCOUNT': "invalid_bank_account",
            'INVALID_BANK_ACCOUNT_VERIFICATION': "invalid_bank_account_verification",
            'INVALID_CHECK_INTERNATIONAL': "invalid_check_international",
            'INVALID_COUNTRY_COVID': "invalid_country_covid",
            'INVALID_FILE': "invalid_file",
            'INVALID_FILE_DIMENSIONS': "invalid_file_dimensions",
            'INVALID_FILE_DOWNLOAD_TIME': "invalid_file_download_time",
            'INVALID_FILE_URL': "invalid_file_url",
            'INVALID_IMAGE_DPI': "invalid_image_dpi",
            'INVALID_INTERNATIONAL_FEATURE': "invalid_international_feature",
            'INVALID_PERFORATION_RETURN_ENVELOPE': "invalid_perforation_return_envelope",
            'INVALID_TEMPLATE_HTML': "invalid_template_html",
            'MERGE_VARIABLE_REQUIRED': "merge_variable_required",
            'MERGE_VARIABLE_WHITESPACE': "merge_variable_whitespace",
            'PAYMENT_METHOD_UNVERIFIED': "payment_method_unverified",
            'PDF_ENCRYPTED': "pdf_encrypted",
            'SPECIAL_CHARACTERS_RESTRICTED': "special_characters_restricted",
            'UNEMBEDDED_FONTS': "unembedded_fonts",
            'EMAIL_REQUIRED': "email_required",
            'INVALID_API_KEY': "invalid_api_key",
            'PUBLISHABLE_KEY_NOT_ALLOWED': "publishable_key_not_allowed",
            'RATE_LIMIT_EXCEEDED': "rate_limit_exceeded",
            'UNAUTHORIZED': "unauthorized",
            'UNAUTHORIZED_TOKEN': "unauthorized_token",
            'CARD_QUANTITY_BELOW_MIN': "card_quantity_below_min",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'message': (str, type(None)),  # noqa: E501
            'status_code': (int, type(None)),  # noqa: E501
            'code': (str, type(None)),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'message': 'message',  # noqa: E501
        'status_code': 'status_code',  # noqa: E501
        'code': 'code',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """LobError - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            message (str, type(None)): A human-readable message with more details about the error. [optional] # noqa: E501
            status_code (int, type(None)): A conventional HTTP status code.. [optional] # noqa: E501
            code (str, type(None)): A pre-defined string identifying an error.. [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """LobError - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            message (str, type(None)): A human-readable message with more details about the error. [optional] # noqa: E501
            status_code (int, type(None)): A conventional HTTP status code.. [optional] # noqa: E501
            code (str, type(None)): A pre-defined string identifying an error.. [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
