# lob-python-sdk
The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.3.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

For more information, please visit [our API documentation](https://docs.lob.com/)

## Requirements

Python

## Getting Started

### Registration

First, you will need to first create an account at [Lob.com](https://dashboard.lob.com/#/register) and obtain your Test and Live API Keys.

Once you have created an account, you can access your API Keys from the [Settings Panel](https://dashboard.lob.com/#/settings).

### Installation & Usage
#### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```

Alternatively you can pull directly from pypi using:

```sh 
pip install lob-python
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import lob_python
```

#### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lob_python
```

## First API Call

```python

import time
import lob_python
from pprint import pprint
from lob_python.api import addresses_api
from lob_python.model.address import Address
from lob_python.model.address_deletion import AddressDeletion
from lob_python.model.address_editable import AddressEditable
from lob_python.model.address_list import AddressList
from lob_python.model.adr_id import AdrId
from lob_python.model.include_model import IncludeModel
from lob_python.model.lob_error import LobError
from lob_python.model.metadata_model import MetadataModel
# Defining the host is optional and defaults to https://api.lob.com/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = lob_python.Configuration(
    host = "https://api.lob.com/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = lob_python.Configuration(
    username = '<<YOUR_LOB_API_KEY>>',
)


# Enter a context with an instance of the API client
with lob_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = addresses_api.AddressesApi(api_client)
    address_editable = AddressEditable(
        address_line1="address_line1_example",
        address_line2="address_line2_example",
        address_city="address_city_example",
        address_state="address_state_example",
        address_zip="address_zip_example",
        address_country=CountryExtended("AD"),
        description=ResourceDescription("description_example"),
        name="name_example",
        company=Company("company_example"),
        phone="phone_example",
        email="email_example",
        metadata=MetadataModel(
            key="key_example",
        ),
    )

    try:
        # create
        api_response = api_instance.create(address_editable)
        pprint(api_response)
    except lob_python.ApiException as e:
        print("Exception when calling AddressesApi->create: %s\n" % e)
```

## API Documentation

The full and comprehensive documentation of Lob's APIs is available [here](https://docs.lob.com/).

## Testing

### Unit Tests

```bash
$ python3 -m unittest discover test/Unit
```

### Integration Tests

Integration tests run against a live deployment of the Lob API and require multiple valid API keys with access to specific features. As such, it is not expected that these tests will pass for every user in every environment.

To run integration tests:

```bash
$ LOB_API_TEST_KEY=<<YOUR TEST KEY>> LOB_API_LIVE_KEY=<<YOUR LIVE KEY>> python3 -m unittest discover test/Integration
```

#### A cleaner alternative if you are going to run integration tests frequently

Run this the first time:

```bash
$ echo "LOB_API_TEST_KEY=<<YOUR TEST KEY>> LOB_API_LIVE_KEY=<<YOUR LIVE KEY>>" > LOCAL.env
```

Then, to run the integration tests:

```bash
$ env $(cat LOCAL.env) python3 -m unittest discover test/Integration
```

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## Author

lob-openapi@lob.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in lob_python.apis and lob_python.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from lob_python.api.default_api import DefaultApi`
- `from lob_python.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import lob_python
from lob_python.apis import *
from lob_python.models import *
```
