"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from lob_python.exceptions import ApiAttributeError

from lob_python.model.buckslip_description import BuckslipDescription
from lob_python.model.buckslip_id import BuckslipId
from lob_python.model.buckslip_order import BuckslipOrder
from lob_python.model.thumbnail import Thumbnail
globals()['BuckslipDescription'] = BuckslipDescription
globals()['BuckslipId'] = BuckslipId
globals()['BuckslipOrder'] = BuckslipOrder
globals()['Thumbnail'] = Thumbnail


class Buckslip(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('stock',): {
            'TEXT': "text",
            'COVER': "cover",
        },
        ('weight',): {
            '80#': "80#",
        },
        ('finish',): {
            'GLOSS': "gloss",
            'MATTE': "matte",
        },
        ('status',): {
            'PROCESSED': "processed",
            'RENDERED': "rendered",
        },
        ('object',): {
            'BUCKSLIP': "buckslip",
        },
        ('size',): {
            '8.75X3.75': "8.75x3.75",
        },
    }

    validations = {
        ('url',): {
            'max_length': 2083,
            'min_length': 1,
        },
        ('raw_url',): {
            'max_length': 2083,
            'min_length': 1,
        },
        ('front_original_url',): {
            'max_length': 2083,
            'min_length': 1,
        },
        ('back_original_url',): {
            'max_length': 2083,
            'min_length': 1,
        },
        ('buckslip_orders',): {
            'min_items': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'id': (str,),  # noqa: E501
            'auto_reorder': (bool,),  # noqa: E501
            'reorder_quantity': (int,),  # noqa: E501
            'threshold_amount': (int,),  # noqa: E501
            'url': (str,),  # noqa: E501
            'raw_url': (str,),  # noqa: E501
            'front_original_url': (str,),  # noqa: E501
            'back_original_url': (str,),  # noqa: E501
            'thumbnails': (list,),  # noqa: E501
            'available_quantity': (float,),  # noqa: E501
            'allocated_quantity': (float,),  # noqa: E501
            'onhand_quantity': (float,),  # noqa: E501
            'pending_quantity': (float,),  # noqa: E501
            'projected_quantity': (float,),  # noqa: E501
            'buckslip_orders': (list,),  # noqa: E501
            'stock': (str,),  # noqa: E501
            'weight': (str,),  # noqa: E501
            'finish': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'object': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'size': (str, type(None)),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'auto_reorder': 'auto_reorder',  # noqa: E501
        'reorder_quantity': 'reorder_quantity',  # noqa: E501
        'threshold_amount': 'threshold_amount',  # noqa: E501
        'url': 'url',  # noqa: E501
        'raw_url': 'raw_url',  # noqa: E501
        'front_original_url': 'front_original_url',  # noqa: E501
        'back_original_url': 'back_original_url',  # noqa: E501
        'thumbnails': 'thumbnails',  # noqa: E501
        'available_quantity': 'available_quantity',  # noqa: E501
        'allocated_quantity': 'allocated_quantity',  # noqa: E501
        'onhand_quantity': 'onhand_quantity',  # noqa: E501
        'pending_quantity': 'pending_quantity',  # noqa: E501
        'projected_quantity': 'projected_quantity',  # noqa: E501
        'buckslip_orders': 'buckslip_orders',  # noqa: E501
        'stock': 'stock',  # noqa: E501
        'weight': 'weight',  # noqa: E501
        'finish': 'finish',  # noqa: E501
        'status': 'status',  # noqa: E501
        'object': 'object',  # noqa: E501
        'description': 'description',  # noqa: E501
        'size': 'size',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, reorder_quantity, url, raw_url, front_original_url, back_original_url, thumbnails, buckslip_orders, stock, finish, status, description, *args, **kwargs):  # noqa: E501
        """Buckslip - a model defined in OpenAPI

        Args:
            id (str):
            reorder_quantity (int): The number of buckslips to be reordered.
            url (str): The signed link for the buckslip.
            raw_url (str): The raw URL of the buckslip.
            front_original_url (str): The original URL of the front template.
            back_original_url (str): The original URL of the back template.
            thumbnails (list):
            buckslip_orders (list): An array of buckslip orders that are associated with the buckslip.
            stock (str):
            finish (str):
            status (str):
            description (str):

        Keyword Args:
            auto_reorder (bool): True if the buckslips should be auto-reordered.. defaults to False  # noqa: E501
            threshold_amount (int): The threshold amount of the buckslip. defaults to 0  # noqa: E501
            available_quantity (float): The available quantity of buckslips.. defaults to 0  # noqa: E501
            allocated_quantity (float): The allocated quantity of buckslips.. defaults to 0  # noqa: E501
            onhand_quantity (float): The onhand quantity of buckslips.. defaults to 0  # noqa: E501
            pending_quantity (float): The pending quantity of buckslips.. defaults to 0  # noqa: E501
            projected_quantity (float): The sum of pending and onhand quantities of buckslips.. defaults to 0  # noqa: E501
            weight (str): defaults to "80#", must be one of ["80#", ]  # noqa: E501
            object (str): object. defaults to "buckslip", must be one of ["buckslip", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            size (str, type(None)): The size of the buckslip. [optional] if omitted the server will use the default value of "8.75x3.75" # noqa: E501
        """

        auto_reorder = kwargs.get('auto_reorder', False)
        threshold_amount = kwargs.get('threshold_amount', 0)
        available_quantity = kwargs.get('available_quantity', 0)
        allocated_quantity = kwargs.get('allocated_quantity', 0)
        onhand_quantity = kwargs.get('onhand_quantity', 0)
        pending_quantity = kwargs.get('pending_quantity', 0)
        projected_quantity = kwargs.get('projected_quantity', 0)
        weight = kwargs.get('weight', "80#")
        object = kwargs.get('object', "buckslip")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.auto_reorder = auto_reorder
        self.reorder_quantity = reorder_quantity
        self.threshold_amount = threshold_amount
        self.url = url
        self.raw_url = raw_url
        self.front_original_url = front_original_url
        self.back_original_url = back_original_url
        self.thumbnails = thumbnails
        self.available_quantity = available_quantity
        self.allocated_quantity = allocated_quantity
        self.onhand_quantity = onhand_quantity
        self.pending_quantity = pending_quantity
        self.projected_quantity = projected_quantity
        self.buckslip_orders = buckslip_orders
        self.stock = stock
        self.weight = weight
        self.finish = finish
        self.status = status
        self.object = object
        self.description = description
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, reorder_quantity, url, raw_url, front_original_url, back_original_url, thumbnails, buckslip_orders, stock, finish, status, description, *args, **kwargs):  # noqa: E501
        """Buckslip - a model defined in OpenAPI

        Args:
            id (BuckslipId):
            reorder_quantity (int, none_type): The number of buckslips to be reordered.
            url (str): The signed link for the buckslip.
            raw_url (str): The raw URL of the buckslip.
            front_original_url (str): The original URL of the front template.
            back_original_url (str): The original URL of the back template.
            thumbnails ([Thumbnail]):
            buckslip_orders ([BuckslipOrder]): An array of buckslip orders that are associated with the buckslip.
            stock (str):
            finish (str):
            status (str):
            description (BuckslipDescription):

        Keyword Args:
            auto_reorder (bool): True if the buckslips should be auto-reordered.. defaults to False  # noqa: E501
            threshold_amount (int): The threshold amount of the buckslip. defaults to 0  # noqa: E501
            available_quantity (float): The available quantity of buckslips.. defaults to 0  # noqa: E501
            allocated_quantity (float): The allocated quantity of buckslips.. defaults to 0  # noqa: E501
            onhand_quantity (float): The onhand quantity of buckslips.. defaults to 0  # noqa: E501
            pending_quantity (float): The pending quantity of buckslips.. defaults to 0  # noqa: E501
            projected_quantity (float): The sum of pending and onhand quantities of buckslips.. defaults to 0  # noqa: E501
            weight (str): defaults to "80#", must be one of ["80#", ]  # noqa: E501
            object (str): object. defaults to "buckslip", must be one of ["buckslip", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            size (str, type(None)): The size of the buckslip. [optional] if omitted the server will use the default value of "8.75x3.75" # noqa: E501
        """

        auto_reorder = kwargs.get('auto_reorder', False)
        threshold_amount = kwargs.get('threshold_amount', 0)
        available_quantity = kwargs.get('available_quantity', 0)
        allocated_quantity = kwargs.get('allocated_quantity', 0)
        onhand_quantity = kwargs.get('onhand_quantity', 0)
        pending_quantity = kwargs.get('pending_quantity', 0)
        projected_quantity = kwargs.get('projected_quantity', 0)
        weight = kwargs.get('weight', "80#")
        object = kwargs.get('object', "buckslip")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.auto_reorder = auto_reorder
        self.reorder_quantity = reorder_quantity
        self.threshold_amount = threshold_amount
        self.url = url
        self.raw_url = raw_url
        self.front_original_url = front_original_url
        self.back_original_url = back_original_url
        self.thumbnails = thumbnails
        self.available_quantity = available_quantity
        self.allocated_quantity = allocated_quantity
        self.onhand_quantity = onhand_quantity
        self.pending_quantity = pending_quantity
        self.projected_quantity = projected_quantity
        self.buckslip_orders = buckslip_orders
        self.stock = stock
        self.weight = weight
        self.finish = finish
        self.status = status
        self.object = object
        self.description = description
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
