"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from lob_python.exceptions import ApiAttributeError



class CountryExtendedExpanded(ModelSimple):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('value',): {
            'EMPTY': "",
            'AFGHANISTAN': "AFGHANISTAN",
            'ALBANIA': "ALBANIA",
            'ALGERIA': "ALGERIA",
            'AMERICAN_SAMOA': "AMERICAN SAMOA",
            'ANDORRA': "ANDORRA",
            'ANGOLA': "ANGOLA",
            'ANGUILLA': "ANGUILLA",
            'ANTARCTICA': "ANTARCTICA",
            'ANTIGUA_AND_BARBUDA': "ANTIGUA AND BARBUDA",
            'ARGENTINA': "ARGENTINA",
            'ARUBA': "ARUBA",
            'AUSTRALIA': "AUSTRALIA",
            'AUSTRIA': "AUSTRIA",
            'AZERBAIJAN': "AZERBAIJAN",
            'BAHRAIN': "BAHRAIN",
            'BANGLADESH': "BANGLADESH",
            'BARBADOS': "BARBADOS",
            'BELARUS': "BELARUS",
            'BELGIUM': "BELGIUM",
            'BELIZE': "BELIZE",
            'BENIN': "BENIN",
            'BERMUDA': "BERMUDA",
            'BHUTAN': "BHUTAN",
            'BOLIVIA_(PLURINATIONAL_STATE_OF)': "BOLIVIA (PLURINATIONAL STATE OF)",
            'BONAIRE,_SAINT_EUSTATIUS_AND_SABA': "BONAIRE, SAINT EUSTATIUS AND SABA",
            'BOSNIA_AND_HERZEGOVINA': "BOSNIA AND HERZEGOVINA",
            'BOTSWANA': "BOTSWANA",
            'BRAZIL': "BRAZIL",
            'BRITISH_INDIAN_OCEAN_TERRITORY': "BRITISH INDIAN OCEAN TERRITORY",
            'BRITISH_VIRGIN_ISLANDS': "BRITISH VIRGIN ISLANDS",
            'BRUNEI_DARUSSALAM': "BRUNEI DARUSSALAM",
            'BULGARIA': "BULGARIA",
            'BURKINA_FASO': "BURKINA FASO",
            'BURUNDI': "BURUNDI",
            'CABO_VERDE': "CABO VERDE",
            'CAMBODIA': "CAMBODIA",
            'CAMEROON': "CAMEROON",
            'CANADA': "CANADA",
            'CAYMAN_ISLANDS': "CAYMAN ISLANDS",
            'CENTRAL_AFRICAN_REPUBLIC': "CENTRAL AFRICAN REPUBLIC",
            'CHAD': "CHAD",
            'CHILE': "CHILE",
            'CHINA': "CHINA",
            'COLOMBIA': "COLOMBIA",
            'COMOROS': "COMOROS",
            'CONGO': "CONGO",
            'CONGO,_DEMOCRATIC_REPUBLIC_OF_THE': "CONGO, DEMOCRATIC REPUBLIC OF THE",
            'COOK_ISLANDS': "COOK ISLANDS",
            'COSTA_RICA': "COSTA RICA",
            'CÔTE_D&#x60;IVOIRE': "CÔTE D`IVOIRE",
            'CROATIA': "CROATIA",
            'CUBA': "CUBA",
            'CURAÇAO': "CURAÇAO",
            'CYPRUS': "CYPRUS",
            'CZECH_REPUBLIC': "CZECH REPUBLIC",
            'DENMARK': "DENMARK",
            'DJIBOUTI': "DJIBOUTI",
            'DOMINICA': "DOMINICA",
            'DOMINICAN_REPUBLIC': "DOMINICAN REPUBLIC",
            'ECUADOR': "ECUADOR",
            'EGYPT': "EGYPT",
            'EL_SALVADOR': "EL SALVADOR",
            'EQUATORIAL_GUINEA': "EQUATORIAL GUINEA",
            'ERITREA': "ERITREA",
            'ESTONIA': "ESTONIA",
            'ESWATINI': "ESWATINI",
            'ETHIOPIA': "ETHIOPIA",
            'FALKLAND_ISLANDS_(MALVINAS)': "FALKLAND ISLANDS (MALVINAS)",
            'FAROE_ISLANDS': "FAROE ISLANDS",
            'FIJI': "FIJI",
            'FINLAND': "FINLAND",
            'FRANCE': "FRANCE",
            'GABON': "GABON",
            'GAMBIA': "GAMBIA",
            'GEORGIA': "GEORGIA",
            'GERMANY': "GERMANY",
            'GHANA': "GHANA",
            'GIBRALTAR': "GIBRALTAR",
            'GREECE': "GREECE",
            'GREENLAND': "GREENLAND",
            'GRENADA': "GRENADA",
            'GUATEMALA': "GUATEMALA",
            'GUINEA': "GUINEA",
            'GUINEA-BISSAU': "GUINEA-BISSAU",
            'GUYANA': "GUYANA",
            'HAITI': "HAITI",
            'HOLY_SEE': "HOLY SEE",
            'HONDURAS': "HONDURAS",
            'HONG_KONG': "HONG KONG",
            'HUNGARY': "HUNGARY",
            'ICELAND': "ICELAND",
            'INDIA': "INDIA",
            'INDONESIA': "INDONESIA",
            'IRAN_(ISLAMIC_REPUBLIC_OF)': "IRAN (ISLAMIC REPUBLIC OF)",
            'IRAQ': "IRAQ",
            'IRELAND': "IRELAND",
            'ISRAEL': "ISRAEL",
            'ITALY': "ITALY",
            'JAMAICA': "JAMAICA",
            'JAPAN': "JAPAN",
            'JORDAN': "JORDAN",
            'KAZAKHSTAN': "KAZAKHSTAN",
            'KENYA': "KENYA",
            'KIRIBATI': "KIRIBATI",
            'KOREA_(DEMOCRATIC_PEOPLE’S_REPUBLIC_OF)': "KOREA (DEMOCRATIC PEOPLE’S REPUBLIC OF)",
            'KOREA,_REPUBLIC_OF': "KOREA, REPUBLIC OF",
            'KUWAIT': "KUWAIT",
            'KYRGYZSTAN': "KYRGYZSTAN",
            'LAO_PEOPLE’S_DEMOCRATIC_REPUBLIC': "LAO PEOPLE’S DEMOCRATIC REPUBLIC",
            'LATVIA': "LATVIA",
            'LEBANON': "LEBANON",
            'LESOTHO': "LESOTHO",
            'LIBERIA': "LIBERIA",
            'LIBYA': "LIBYA",
            'LIECHTENSTEIN': "LIECHTENSTEIN",
            'LITHUANIA': "LITHUANIA",
            'LUXEMBOURG': "LUXEMBOURG",
            'MACAO': "MACAO",
            'MACEDONIA': "MACEDONIA",
            'MADAGASCAR': "MADAGASCAR",
            'MALAWI': "MALAWI",
            'MALAYSIA': "MALAYSIA",
            'MALDIVES': "MALDIVES",
            'MALI': "MALI",
            'MALTA': "MALTA",
            'MAURITANIA': "MAURITANIA",
            'MAURITIUS': "MAURITIUS",
            'MEXICO': "MEXICO",
            'MOLDOVA,_REPUBLIC_OF': "MOLDOVA, REPUBLIC OF",
            'MONACO': "MONACO",
            'MONGOLIA': "MONGOLIA",
            'MONTENEGRO': "MONTENEGRO",
            'MONTSERRAT': "MONTSERRAT",
            'MOROCCO': "MOROCCO",
            'MOZAMBIQUE': "MOZAMBIQUE",
            'MYANMAR': "MYANMAR",
            'NAMIBIA': "NAMIBIA",
            'NAURU': "NAURU",
            'NEPAL': "NEPAL",
            'NETHERLAND_ANTILLES': "NETHERLAND ANTILLES",
            'NETHERLANDS': "NETHERLANDS",
            'NEW_ZEALAND': "NEW ZEALAND",
            'NICARAGUA': "NICARAGUA",
            'NIGER': "NIGER",
            'NIGERIA': "NIGERIA",
            'NIUE': "NIUE",
            'NORFOLK_ISLAND': "NORFOLK ISLAND",
            'NORWAY': "NORWAY",
            'OMAN': "OMAN",
            'PAKISTAN': "PAKISTAN",
            'PANAMA': "PANAMA",
            'PAPUA_NEW_GUINEA': "PAPUA NEW GUINEA",
            'PARAGUAY': "PARAGUAY",
            'PERU': "PERU",
            'PHILIPPINES': "PHILIPPINES",
            'PITCAIRN': "PITCAIRN",
            'POLAND': "POLAND",
            'PORTUGAL': "PORTUGAL",
            'QATAR': "QATAR",
            'ROMANIA': "ROMANIA",
            'RUSSIAN_FEDERATION': "RUSSIAN FEDERATION",
            'RWANDA': "RWANDA",
            'SAINT_HELENA': "SAINT HELENA",
            'SAINT_KITTS_AND_NEVIS': "SAINT KITTS AND NEVIS",
            'SAINT_LUCIA': "SAINT LUCIA",
            'SAINT_VINCENT_AND_THE_GRENADINES': "SAINT VINCENT AND THE GRENADINES",
            'SAMOA': "SAMOA",
            'SAN_MARINO': "SAN MARINO",
            'SAO_TOME_AND_PRINCIPE': "SAO TOME AND PRINCIPE",
            'SAUDI_ARABIA': "SAUDI ARABIA",
            'SENEGAL': "SENEGAL",
            'SERBIA': "SERBIA",
            'SEYCHELLES': "SEYCHELLES",
            'SIERRA_LEONE': "SIERRA LEONE",
            'SINGAPORE': "SINGAPORE",
            'SINT_MAARTEN': "SINT MAARTEN",
            'SLOVAKIA': "SLOVAKIA",
            'SLOVENIA': "SLOVENIA",
            'SOLOMON_ISLANDS': "SOLOMON ISLANDS",
            'SOMALIA': "SOMALIA",
            'SOUTH_AFRICA': "SOUTH AFRICA",
            'SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS': "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS",
            'SOUTH_SUDAN': "SOUTH SUDAN",
            'SPAIN': "SPAIN",
            'SRI_LANKA': "SRI LANKA",
            'SUDAN': "SUDAN",
            'SURINAME': "SURINAME",
            'SWEDEN': "SWEDEN",
            'SWITZERLAND': "SWITZERLAND",
            'SYRIAN_ARAB_REPUBLIC': "SYRIAN ARAB REPUBLIC",
            'TAIWAN': "TAIWAN",
            'TAJIKISTAN': "TAJIKISTAN",
            'TANZANIA': "TANZANIA",
            'THAILAND': "THAILAND",
            'THE_BAHAMAS': "THE BAHAMAS",
            'TIMOR-LESTE': "TIMOR-LESTE",
            'TOGO': "TOGO",
            'TOKELAU': "TOKELAU",
            'TONGA': "TONGA",
            'TRINIDAD_AND_TOBAGO': "TRINIDAD AND TOBAGO",
            'TUNISIA': "TUNISIA",
            'TURKEY': "TURKEY",
            'TURKMENISTAN': "TURKMENISTAN",
            'TURKS_AND_CAICOS_ISLANDS': "TURKS AND CAICOS ISLANDS",
            'TUVALU': "TUVALU",
            'UGANDA': "UGANDA",
            'UKRAINE': "UKRAINE",
            'UNITED_ARAB_EMIRATES': "UNITED ARAB EMIRATES",
            'UNITED_KINGDOM': "UNITED KINGDOM",
            'UNITED_STATES': "UNITED STATES",
            'URUGUAY': "URUGUAY",
            'UZBEKISTAN': "UZBEKISTAN",
            'VANUATU': "VANUATU",
            'VENEZUELA': "VENEZUELA",
            'VIET_NAM': "VIET NAM",
            'WESTERN_SAHARA': "WESTERN SAHARA",
            'YEMEN': "YEMEN",
            'ZAMBIA': "ZAMBIA",
            'ZIMBABWE': "ZIMBABWE",
        },
    }

    validations = {
        ('value',): {
            'max_length': 200,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'value': (str,),
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {}

    read_only_vars = set()

    _composed_schemas = None

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):
        """CountryExtendedExpanded - a model defined in OpenAPI

        Note that value can be passed either in args or in kwargs, but not in both.

        Args:
            args[0] (str): Full name of country., must be one of ["", "AFGHANISTAN", "ALBANIA", "ALGERIA", "AMERICAN SAMOA", "ANDORRA", "ANGOLA", "ANGUILLA", "ANTARCTICA", "ANTIGUA AND BARBUDA", "ARGENTINA", "ARUBA", "AUSTRALIA", "AUSTRIA", "AZERBAIJAN", "BAHRAIN", "BANGLADESH", "BARBADOS", "BELARUS", "BELGIUM", "BELIZE", "BENIN", "BERMUDA", "BHUTAN", "BOLIVIA (PLURINATIONAL STATE OF)", "BONAIRE, SAINT EUSTATIUS AND SABA", "BOSNIA AND HERZEGOVINA", "BOTSWANA", "BRAZIL", "BRITISH INDIAN OCEAN TERRITORY", "BRITISH VIRGIN ISLANDS", "BRUNEI DARUSSALAM", "BULGARIA", "BURKINA FASO", "BURUNDI", "CABO VERDE", "CAMBODIA", "CAMEROON", "CANADA", "CAYMAN ISLANDS", "CENTRAL AFRICAN REPUBLIC", "CHAD", "CHILE", "CHINA", "COLOMBIA", "COMOROS", "CONGO", "CONGO, DEMOCRATIC REPUBLIC OF THE", "COOK ISLANDS", "COSTA RICA", "CÔTE D`IVOIRE", "CROATIA", "CUBA", "CURAÇAO", "CYPRUS", "CZECH REPUBLIC", "DENMARK", "DJIBOUTI", "DOMINICA", "DOMINICAN REPUBLIC", "ECUADOR", "EGYPT", "EL SALVADOR", "EQUATORIAL GUINEA", "ERITREA", "ESTONIA", "ESWATINI", "ETHIOPIA", "FALKLAND ISLANDS (MALVINAS)", "FAROE ISLANDS", "FIJI", "FINLAND", "FRANCE", "GABON", "GAMBIA", "GEORGIA", "GERMANY", "GHANA", "GIBRALTAR", "GREECE", "GREENLAND", "GRENADA", "GUATEMALA", "GUINEA", "GUINEA-BISSAU", "GUYANA", "HAITI", "HOLY SEE", "HONDURAS", "HONG KONG", "HUNGARY", "ICELAND", "INDIA", "INDONESIA", "IRAN (ISLAMIC REPUBLIC OF)", "IRAQ", "IRELAND", "ISRAEL", "ITALY", "JAMAICA", "JAPAN", "JORDAN", "KAZAKHSTAN", "KENYA", "KIRIBATI", "KOREA (DEMOCRATIC PEOPLE’S REPUBLIC OF)", "KOREA, REPUBLIC OF", "KUWAIT", "KYRGYZSTAN", "LAO PEOPLE’S DEMOCRATIC REPUBLIC", "LATVIA", "LEBANON", "LESOTHO", "LIBERIA", "LIBYA", "LIECHTENSTEIN", "LITHUANIA", "LUXEMBOURG", "MACAO", "MACEDONIA", "MADAGASCAR", "MALAWI", "MALAYSIA", "MALDIVES", "MALI", "MALTA", "MAURITANIA", "MAURITIUS", "MEXICO", "MOLDOVA, REPUBLIC OF", "MONACO", "MONGOLIA", "MONTENEGRO", "MONTSERRAT", "MOROCCO", "MOZAMBIQUE", "MYANMAR", "NAMIBIA", "NAURU", "NEPAL", "NETHERLAND ANTILLES", "NETHERLANDS", "NEW ZEALAND", "NICARAGUA", "NIGER", "NIGERIA", "NIUE", "NORFOLK ISLAND", "NORWAY", "OMAN", "PAKISTAN", "PANAMA", "PAPUA NEW GUINEA", "PARAGUAY", "PERU", "PHILIPPINES", "PITCAIRN", "POLAND", "PORTUGAL", "QATAR", "ROMANIA", "RUSSIAN FEDERATION", "RWANDA", "SAINT HELENA", "SAINT KITTS AND NEVIS", "SAINT LUCIA", "SAINT VINCENT AND THE GRENADINES", "SAMOA", "SAN MARINO", "SAO TOME AND PRINCIPE", "SAUDI ARABIA", "SENEGAL", "SERBIA", "SEYCHELLES", "SIERRA LEONE", "SINGAPORE", "SINT MAARTEN", "SLOVAKIA", "SLOVENIA", "SOLOMON ISLANDS", "SOMALIA", "SOUTH AFRICA", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS", "SOUTH SUDAN", "SPAIN", "SRI LANKA", "SUDAN", "SURINAME", "SWEDEN", "SWITZERLAND", "SYRIAN ARAB REPUBLIC", "TAIWAN", "TAJIKISTAN", "TANZANIA", "THAILAND", "THE BAHAMAS", "TIMOR-LESTE", "TOGO", "TOKELAU", "TONGA", "TRINIDAD AND TOBAGO", "TUNISIA", "TURKEY", "TURKMENISTAN", "TURKS AND CAICOS ISLANDS", "TUVALU", "UGANDA", "UKRAINE", "UNITED ARAB EMIRATES", "UNITED KINGDOM", "UNITED STATES", "URUGUAY", "UZBEKISTAN", "VANUATU", "VENEZUELA", "VIET NAM", "WESTERN SAHARA", "YEMEN", "ZAMBIA", "ZIMBABWE", ]  # noqa: E501
        Keyword Args:
            value (): Full name of country., must be one of ["", "AFGHANISTAN", "ALBANIA", "ALGERIA", "AMERICAN SAMOA", "ANDORRA", "ANGOLA", "ANGUILLA", "ANTARCTICA", "ANTIGUA AND BARBUDA", "ARGENTINA", "ARUBA", "AUSTRALIA", "AUSTRIA", "AZERBAIJAN", "BAHRAIN", "BANGLADESH", "BARBADOS", "BELARUS", "BELGIUM", "BELIZE", "BENIN", "BERMUDA", "BHUTAN", "BOLIVIA (PLURINATIONAL STATE OF)", "BONAIRE, SAINT EUSTATIUS AND SABA", "BOSNIA AND HERZEGOVINA", "BOTSWANA", "BRAZIL", "BRITISH INDIAN OCEAN TERRITORY", "BRITISH VIRGIN ISLANDS", "BRUNEI DARUSSALAM", "BULGARIA", "BURKINA FASO", "BURUNDI", "CABO VERDE", "CAMBODIA", "CAMEROON", "CANADA", "CAYMAN ISLANDS", "CENTRAL AFRICAN REPUBLIC", "CHAD", "CHILE", "CHINA", "COLOMBIA", "COMOROS", "CONGO", "CONGO, DEMOCRATIC REPUBLIC OF THE", "COOK ISLANDS", "COSTA RICA", "CÔTE D`IVOIRE", "CROATIA", "CUBA", "CURAÇAO", "CYPRUS", "CZECH REPUBLIC", "DENMARK", "DJIBOUTI", "DOMINICA", "DOMINICAN REPUBLIC", "ECUADOR", "EGYPT", "EL SALVADOR", "EQUATORIAL GUINEA", "ERITREA", "ESTONIA", "ESWATINI", "ETHIOPIA", "FALKLAND ISLANDS (MALVINAS)", "FAROE ISLANDS", "FIJI", "FINLAND", "FRANCE", "GABON", "GAMBIA", "GEORGIA", "GERMANY", "GHANA", "GIBRALTAR", "GREECE", "GREENLAND", "GRENADA", "GUATEMALA", "GUINEA", "GUINEA-BISSAU", "GUYANA", "HAITI", "HOLY SEE", "HONDURAS", "HONG KONG", "HUNGARY", "ICELAND", "INDIA", "INDONESIA", "IRAN (ISLAMIC REPUBLIC OF)", "IRAQ", "IRELAND", "ISRAEL", "ITALY", "JAMAICA", "JAPAN", "JORDAN", "KAZAKHSTAN", "KENYA", "KIRIBATI", "KOREA (DEMOCRATIC PEOPLE’S REPUBLIC OF)", "KOREA, REPUBLIC OF", "KUWAIT", "KYRGYZSTAN", "LAO PEOPLE’S DEMOCRATIC REPUBLIC", "LATVIA", "LEBANON", "LESOTHO", "LIBERIA", "LIBYA", "LIECHTENSTEIN", "LITHUANIA", "LUXEMBOURG", "MACAO", "MACEDONIA", "MADAGASCAR", "MALAWI", "MALAYSIA", "MALDIVES", "MALI", "MALTA", "MAURITANIA", "MAURITIUS", "MEXICO", "MOLDOVA, REPUBLIC OF", "MONACO", "MONGOLIA", "MONTENEGRO", "MONTSERRAT", "MOROCCO", "MOZAMBIQUE", "MYANMAR", "NAMIBIA", "NAURU", "NEPAL", "NETHERLAND ANTILLES", "NETHERLANDS", "NEW ZEALAND", "NICARAGUA", "NIGER", "NIGERIA", "NIUE", "NORFOLK ISLAND", "NORWAY", "OMAN", "PAKISTAN", "PANAMA", "PAPUA NEW GUINEA", "PARAGUAY", "PERU", "PHILIPPINES", "PITCAIRN", "POLAND", "PORTUGAL", "QATAR", "ROMANIA", "RUSSIAN FEDERATION", "RWANDA", "SAINT HELENA", "SAINT KITTS AND NEVIS", "SAINT LUCIA", "SAINT VINCENT AND THE GRENADINES", "SAMOA", "SAN MARINO", "SAO TOME AND PRINCIPE", "SAUDI ARABIA", "SENEGAL", "SERBIA", "SEYCHELLES", "SIERRA LEONE", "SINGAPORE", "SINT MAARTEN", "SLOVAKIA", "SLOVENIA", "SOLOMON ISLANDS", "SOMALIA", "SOUTH AFRICA", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS", "SOUTH SUDAN", "SPAIN", "SRI LANKA", "SUDAN", "SURINAME", "SWEDEN", "SWITZERLAND", "SYRIAN ARAB REPUBLIC", "TAIWAN", "TAJIKISTAN", "TANZANIA", "THAILAND", "THE BAHAMAS", "TIMOR-LESTE", "TOGO", "TOKELAU", "TONGA", "TRINIDAD AND TOBAGO", "TUNISIA", "TURKEY", "TURKMENISTAN", "TURKS AND CAICOS ISLANDS", "TUVALU", "UGANDA", "UKRAINE", "UNITED ARAB EMIRATES", "UNITED KINGDOM", "UNITED STATES", "URUGUAY", "UZBEKISTAN", "VANUATU", "VENEZUELA", "VIET NAM", "WESTERN SAHARA", "YEMEN", "ZAMBIA", "ZIMBABWE", ]  # noqa: E501

            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """
        # required up here when default value is not given
        _path_to_item = kwargs.pop('_path_to_item', ())

        if 'value' in kwargs:
            value = kwargs.pop('value')
        elif args:
            args = list(args)
            value = args.pop(0)
        else:
            raise ApiTypeError(
                "value is required, but not passed in args or kwargs and doesn't have default",
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)
        self.value = value
        if kwargs:
            raise ApiTypeError(
                "Invalid named arguments=%s passed to %s. Remove those invalid named arguments." % (
                    kwargs,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):
        """CountryExtendedExpanded - a model defined in OpenAPI

        Note that value can be passed either in args or in kwargs, but not in both.

        Args:
            args[0] (str): Full name of country., must be one of ["", "AFGHANISTAN", "ALBANIA", "ALGERIA", "AMERICAN SAMOA", "ANDORRA", "ANGOLA", "ANGUILLA", "ANTARCTICA", "ANTIGUA AND BARBUDA", "ARGENTINA", "ARUBA", "AUSTRALIA", "AUSTRIA", "AZERBAIJAN", "BAHRAIN", "BANGLADESH", "BARBADOS", "BELARUS", "BELGIUM", "BELIZE", "BENIN", "BERMUDA", "BHUTAN", "BOLIVIA (PLURINATIONAL STATE OF)", "BONAIRE, SAINT EUSTATIUS AND SABA", "BOSNIA AND HERZEGOVINA", "BOTSWANA", "BRAZIL", "BRITISH INDIAN OCEAN TERRITORY", "BRITISH VIRGIN ISLANDS", "BRUNEI DARUSSALAM", "BULGARIA", "BURKINA FASO", "BURUNDI", "CABO VERDE", "CAMBODIA", "CAMEROON", "CANADA", "CAYMAN ISLANDS", "CENTRAL AFRICAN REPUBLIC", "CHAD", "CHILE", "CHINA", "COLOMBIA", "COMOROS", "CONGO", "CONGO, DEMOCRATIC REPUBLIC OF THE", "COOK ISLANDS", "COSTA RICA", "CÔTE D`IVOIRE", "CROATIA", "CUBA", "CURAÇAO", "CYPRUS", "CZECH REPUBLIC", "DENMARK", "DJIBOUTI", "DOMINICA", "DOMINICAN REPUBLIC", "ECUADOR", "EGYPT", "EL SALVADOR", "EQUATORIAL GUINEA", "ERITREA", "ESTONIA", "ESWATINI", "ETHIOPIA", "FALKLAND ISLANDS (MALVINAS)", "FAROE ISLANDS", "FIJI", "FINLAND", "FRANCE", "GABON", "GAMBIA", "GEORGIA", "GERMANY", "GHANA", "GIBRALTAR", "GREECE", "GREENLAND", "GRENADA", "GUATEMALA", "GUINEA", "GUINEA-BISSAU", "GUYANA", "HAITI", "HOLY SEE", "HONDURAS", "HONG KONG", "HUNGARY", "ICELAND", "INDIA", "INDONESIA", "IRAN (ISLAMIC REPUBLIC OF)", "IRAQ", "IRELAND", "ISRAEL", "ITALY", "JAMAICA", "JAPAN", "JORDAN", "KAZAKHSTAN", "KENYA", "KIRIBATI", "KOREA (DEMOCRATIC PEOPLE’S REPUBLIC OF)", "KOREA, REPUBLIC OF", "KUWAIT", "KYRGYZSTAN", "LAO PEOPLE’S DEMOCRATIC REPUBLIC", "LATVIA", "LEBANON", "LESOTHO", "LIBERIA", "LIBYA", "LIECHTENSTEIN", "LITHUANIA", "LUXEMBOURG", "MACAO", "MACEDONIA", "MADAGASCAR", "MALAWI", "MALAYSIA", "MALDIVES", "MALI", "MALTA", "MAURITANIA", "MAURITIUS", "MEXICO", "MOLDOVA, REPUBLIC OF", "MONACO", "MONGOLIA", "MONTENEGRO", "MONTSERRAT", "MOROCCO", "MOZAMBIQUE", "MYANMAR", "NAMIBIA", "NAURU", "NEPAL", "NETHERLAND ANTILLES", "NETHERLANDS", "NEW ZEALAND", "NICARAGUA", "NIGER", "NIGERIA", "NIUE", "NORFOLK ISLAND", "NORWAY", "OMAN", "PAKISTAN", "PANAMA", "PAPUA NEW GUINEA", "PARAGUAY", "PERU", "PHILIPPINES", "PITCAIRN", "POLAND", "PORTUGAL", "QATAR", "ROMANIA", "RUSSIAN FEDERATION", "RWANDA", "SAINT HELENA", "SAINT KITTS AND NEVIS", "SAINT LUCIA", "SAINT VINCENT AND THE GRENADINES", "SAMOA", "SAN MARINO", "SAO TOME AND PRINCIPE", "SAUDI ARABIA", "SENEGAL", "SERBIA", "SEYCHELLES", "SIERRA LEONE", "SINGAPORE", "SINT MAARTEN", "SLOVAKIA", "SLOVENIA", "SOLOMON ISLANDS", "SOMALIA", "SOUTH AFRICA", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS", "SOUTH SUDAN", "SPAIN", "SRI LANKA", "SUDAN", "SURINAME", "SWEDEN", "SWITZERLAND", "SYRIAN ARAB REPUBLIC", "TAIWAN", "TAJIKISTAN", "TANZANIA", "THAILAND", "THE BAHAMAS", "TIMOR-LESTE", "TOGO", "TOKELAU", "TONGA", "TRINIDAD AND TOBAGO", "TUNISIA", "TURKEY", "TURKMENISTAN", "TURKS AND CAICOS ISLANDS", "TUVALU", "UGANDA", "UKRAINE", "UNITED ARAB EMIRATES", "UNITED KINGDOM", "UNITED STATES", "URUGUAY", "UZBEKISTAN", "VANUATU", "VENEZUELA", "VIET NAM", "WESTERN SAHARA", "YEMEN", "ZAMBIA", "ZIMBABWE", ]  # noqa: E501

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """
        # required up here when default value is not given
        _path_to_item = kwargs.pop('_path_to_item', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if 'value' in kwargs:
            value = kwargs.pop('value')
        elif args:
            args = list(args)
            value = args.pop(0)
        else:
            raise ApiTypeError(
                "value is required, but not passed in args or kwargs and doesn't have default",
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)
        self.value = value
        if kwargs:
            raise ApiTypeError(
                "Invalid named arguments=%s passed to %s. Remove those invalid named arguments." % (
                    kwargs,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        return self
