"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.api_client import ApiClient, Endpoint as _Endpoint
from lob_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lob_python.model.lob_error import LobError
from lob_python.model.multiple_components_list import MultipleComponentsList
from lob_python.model.us_verification import UsVerification
from lob_python.model.us_verifications import UsVerifications
from lob_python.model.us_verifications_writable import UsVerificationsWritable


class UsVerificationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.verifyBulk_endpoint = _Endpoint(
            settings={
                'response_type': (UsVerifications,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/bulk/us_verifications',
                'operation_id': 'verifyBulk',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'multiple_components_list',
                    'case',
                ],
                'required': [
                    'multiple_components_list',
                ],
                'nullable': [
                ],
                'enum': [
                    'case',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('case',): {

                        "UPPER": "upper",
                        "PROPER": "proper"
                    },
                },
                'openapi_types': {
                    'multiple_components_list':
                        (MultipleComponentsList,),
                    'case':
                        (str,),
                },
                'attribute_map': {
                    'case': 'case',
                },
                'location_map': {
                    'multiple_components_list': 'body',
                    'case': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.verifySingle_endpoint = _Endpoint(
            settings={
                'response_type': (UsVerification,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/us_verifications',
                'operation_id': 'verifySingle',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'us_verifications_writable',
                    'case',
                ],
                'required': [
                    'us_verifications_writable',
                ],
                'nullable': [
                ],
                'enum': [
                    'case',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('case',): {

                        "UPPER": "upper",
                        "PROPER": "proper"
                    },
                },
                'openapi_types': {
                    'us_verifications_writable':
                        (UsVerificationsWritable,),
                    'case':
                        (str,),
                },
                'attribute_map': {
                    'case': 'case',
                },
                'location_map': {
                    'us_verifications_writable': 'body',
                    'case': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def verifyBulk(
        self,
        multiple_components_list,
        **kwargs
    ):
        """verifyBulk  # noqa: E501

        Verify a list of US or US territory addresses with a live API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verifyBulk(multiple_components_list, async_req=True)
        >>> result = thread.get()

        Args:
            multiple_components_list (MultipleComponentsList):

        Keyword Args:
            case (str): Casing of the verified address. Possible values are `upper` and `proper` for uppercased (e.g. \"PO BOX\") and proper-cased (e.g. \"PO Box\"), respectively.. [optional] if omitted the server will use the default value of "upper"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsVerifications
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['multiple_components_list'] = \
            multiple_components_list
        return self.verifyBulk_endpoint.call_with_http_info(**kwargs)

    def verifySingle(
        self,
        us_verifications_writable,
        **kwargs
    ):
        """verifySingle  # noqa: E501

        Verify a US or US territory address with a live API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verifySingle(us_verifications_writable, async_req=True)
        >>> result = thread.get()

        Args:
            us_verifications_writable (UsVerificationsWritable):

        Keyword Args:
            case (str): Casing of the verified address. Possible values are `upper` and `proper` for uppercased (e.g. \"PO BOX\") and proper-cased (e.g. \"PO Box\"), respectively.. [optional] if omitted the server will use the default value of "upper"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsVerification
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['us_verifications_writable'] = \
            us_verifications_writable
        return self.verifySingle_endpoint.call_with_http_info(**kwargs)

