"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from lob_python.exceptions import ApiAttributeError

from lob_python.model.optional_address_column_mapping import OptionalAddressColumnMapping
from lob_python.model.required_address_column_mapping import RequiredAddressColumnMapping
from lob_python.model.upl_id import UplId
from lob_python.model.upload_state import UploadState
from lob_python.model.uploads_metadata import UploadsMetadata
globals()['OptionalAddressColumnMapping'] = OptionalAddressColumnMapping
globals()['RequiredAddressColumnMapping'] = RequiredAddressColumnMapping
globals()['UplId'] = UplId
globals()['UploadState'] = UploadState
globals()['UploadsMetadata'] = UploadsMetadata


class Upload(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('mode',): {
            'TEST': "test",
            'LIVE': "live",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'id': (str,),  # noqa: E501
            'account_id': (str,),  # noqa: E501
            'mode': (str,),  # noqa: E501
            'state': (UploadState,),  # noqa: E501
            'total_mailpieces': (int,),  # noqa: E501
            'failed_mailpieces': (int,),  # noqa: E501
            'validated_mailpieces': (int,),  # noqa: E501
            'bytes_processed': (int,),  # noqa: E501
            'date_created': (datetime,),  # noqa: E501
            'date_modified': (datetime,),  # noqa: E501
            'required_address_column_mapping': (RequiredAddressColumnMapping,),  # noqa: E501
            'optional_address_column_mapping': (OptionalAddressColumnMapping,),  # noqa: E501
            'metadata': (UploadsMetadata,),  # noqa: E501
            'merge_variable_column_mapping': (dict,),  # noqa: E501
            'failures_url': (str, type(None)),  # noqa: E501
            'original_filename': (str, type(None)),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'account_id': 'accountId',  # noqa: E501
        'mode': 'mode',  # noqa: E501
        'state': 'state',  # noqa: E501
        'total_mailpieces': 'totalMailpieces',  # noqa: E501
        'failed_mailpieces': 'failedMailpieces',  # noqa: E501
        'validated_mailpieces': 'validatedMailpieces',  # noqa: E501
        'bytes_processed': 'bytesProcessed',  # noqa: E501
        'date_created': 'dateCreated',  # noqa: E501
        'date_modified': 'dateModified',  # noqa: E501
        'required_address_column_mapping': 'requiredAddressColumnMapping',  # noqa: E501
        'optional_address_column_mapping': 'optionalAddressColumnMapping',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'merge_variable_column_mapping': 'mergeVariableColumnMapping',  # noqa: E501
        'failures_url': 'failuresUrl',  # noqa: E501
        'original_filename': 'originalFilename',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, id, account_id, mode, state, total_mailpieces, failed_mailpieces, validated_mailpieces, bytes_processed, date_created, date_modified, required_address_column_mapping, optional_address_column_mapping, metadata, merge_variable_column_mapping, *args, **kwargs):  # noqa: E501
        """Upload - a model defined in OpenAPI

        Args:
            id (str):
            account_id (str): Account ID that made the request
            mode (str): The environment in which the mailpieces were created. Today, will only be `live`.
            state (UploadState):
            total_mailpieces (int): Total number of recipients for the campaign
            failed_mailpieces (int): Number of mailpieces that failed to create
            validated_mailpieces (int): Number of mailpieces that were successfully created
            bytes_processed (int): Number of bytes processed in your CSV
            date_created (datetime): A timestamp in ISO 8601 format of the date the upload was created
            date_modified (datetime): A timestamp in ISO 8601 format of the date the upload was last modified
            required_address_column_mapping (RequiredAddressColumnMapping):
            optional_address_column_mapping (OptionalAddressColumnMapping):
            metadata (UploadsMetadata):
            merge_variable_column_mapping (dict): The mapping of column headers in your file to the merge variables present in your creative. See our <a href=\"https://help.lob.com/print-and-mail/building-a-mail-strategy/campaign-or-triggered-sends/campaign-audience-guide#step-3-map-merge-variable-data-if-applicable-7\" target=\"_blank\">Campaign Audience Guide</a> for additional details. <br />If a merge variable has the same \"name\" as a \"key\" in the `requiredAddressColumnMapping` or `optionalAddressColumnMapping` objects, then they **CANNOT** have a different value in this object. If a different value is provided, then when the campaign is processing it will get overwritten with the mapped value present in the `requiredAddressColumnMapping` or `optionalAddressColumnMapping` objects.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            failures_url (str, type(None)): Url where your campaign mailpiece failures can be retrieved. [optional] # noqa: E501
            original_filename (str, type(None)): Filename of the upload. [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.account_id = account_id
        self.mode = mode
        self.state = state
        self.total_mailpieces = total_mailpieces
        self.failed_mailpieces = failed_mailpieces
        self.validated_mailpieces = validated_mailpieces
        self.bytes_processed = bytes_processed
        self.date_created = date_created
        self.date_modified = date_modified
        self.required_address_column_mapping = required_address_column_mapping
        self.optional_address_column_mapping = optional_address_column_mapping
        self.metadata = metadata
        self.merge_variable_column_mapping = merge_variable_column_mapping
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, id, account_id, mode, state, total_mailpieces, failed_mailpieces, validated_mailpieces, bytes_processed, date_created, date_modified, required_address_column_mapping, optional_address_column_mapping, metadata, merge_variable_column_mapping, *args, **kwargs):  # noqa: E501
        """Upload - a model defined in OpenAPI

        Args:
            id (UplId):
            account_id (str): Account ID that made the request
            mode (str): The environment in which the mailpieces were created. Today, will only be `live`.
            state (UploadState):
            total_mailpieces (int): Total number of recipients for the campaign
            failed_mailpieces (int): Number of mailpieces that failed to create
            validated_mailpieces (int): Number of mailpieces that were successfully created
            bytes_processed (int): Number of bytes processed in your CSV
            date_created (datetime): A timestamp in ISO 8601 format of the date the upload was created
            date_modified (datetime): A timestamp in ISO 8601 format of the date the upload was last modified
            required_address_column_mapping (RequiredAddressColumnMapping):
            optional_address_column_mapping (OptionalAddressColumnMapping):
            metadata (UploadsMetadata):
            merge_variable_column_mapping ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): The mapping of column headers in your file to the merge variables present in your creative. See our <a href=\"https://help.lob.com/print-and-mail/building-a-mail-strategy/campaign-or-triggered-sends/campaign-audience-guide#step-3-map-merge-variable-data-if-applicable-7\" target=\"_blank\">Campaign Audience Guide</a> for additional details. <br />If a merge variable has the same \"name\" as a \"key\" in the `requiredAddressColumnMapping` or `optionalAddressColumnMapping` objects, then they **CANNOT** have a different value in this object. If a different value is provided, then when the campaign is processing it will get overwritten with the mapped value present in the `requiredAddressColumnMapping` or `optionalAddressColumnMapping` objects.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            failures_url (str, type(None)): Url where your campaign mailpiece failures can be retrieved. [optional] # noqa: E501
            original_filename (str, type(None)): Filename of the upload. [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.id = id
        self.account_id = account_id
        self.mode = mode
        self.state = state
        self.total_mailpieces = total_mailpieces
        self.failed_mailpieces = failed_mailpieces
        self.validated_mailpieces = validated_mailpieces
        self.bytes_processed = bytes_processed
        self.date_created = date_created
        self.date_modified = date_modified
        self.required_address_column_mapping = required_address_column_mapping
        self.optional_address_column_mapping = optional_address_column_mapping
        self.metadata = metadata
        self.merge_variable_column_mapping = merge_variable_column_mapping
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
