_C=False
_B=True
_A=None
import hashlib,json,logging,os,zipfile
from typing import Dict,List,Optional,Set,Tuple,TypedDict,Union
from localstack.constants import TEST_AWS_ACCOUNT_ID
from localstack.utils.files import cp_r,load_file,mkdir,rm_rf,save_file
from localstack.utils.http import safe_requests
from localstack.utils.strings import short_uid,to_str
from localstack_ext.bootstrap.pods.constants import NIL_PTR,VERSIONS_ARCHIVE
from localstack_ext.bootstrap.pods.models import Commit,Revision,StateFileRef,Version
from localstack_ext.bootstrap.pods.object_storage import get_object_storage_provider
from localstack_ext.bootstrap.pods.service_state.service_state import ServiceState
from localstack_ext.bootstrap.pods.service_state.service_state_types import BackendState,ServiceKey
from localstack_ext.bootstrap.pods.utils.adapters import ServiceStateMarshaller
from localstack_ext.bootstrap.pods.utils.common import PodsConfigContext,zip_directories
from localstack_ext.bootstrap.pods.utils.hash_utils import compute_file_hash,compute_revision_hash,random_hash
from localstack_ext.bootstrap.pods.utils.metamodel_utils import CommitMetamodelUtils
from localstack_ext.bootstrap.pods.utils.remote_utils import merge_from_versions_archive
from localstack_ext.constants import API_STATES_DIR
LOG=logging.getLogger(__name__)
class CloudPodPreSignedUrls(TypedDict):state_archive_url:Optional[str];metadata_archive_url:Optional[str];versions_archive_url:Optional[str]
class CloudPodsClientApi:
	def __init__(A,config_context):A.config_context=config_context;A.object_storage=get_object_storage_provider(A.config_context);A.commit_metamodel_utils=CommitMetamodelUtils(A.config_context)
	def init(A,pod_name=_A):
		B=pod_name;B=B or A.config_context.pod_name
		if A.config_context.pod_exists_locally(pod_name=B):LOG.warning(f"Pod with name {B} already exists locally");return
		mkdir(A.config_context.get_pod_root_dir());mkdir(A.config_context.get_versions_path());mkdir(A.config_context.get_obj_store_path());A.config_context.set_pod_context(B);C=random_hash();E=random_hash();F=Revision(hash_ref=C,parent_ptr=NIL_PTR,creator=A.config_context.get_context_user(),rid=short_uid(),revision_number=0,state_files=set());D=Version(hash_ref=E,parent_ptr=NIL_PTR,creator=A.config_context.get_context_user(),comment='Initial version',outgoing_revision_ptrs={C},incoming_revision_ptr=_A,state_files=set(),version_number=Version.DEFAULT_INITIAL_VERSION_NUMBER);D.revisions.append(F);A.object_storage.upsert_objects(D);LOG.debug('Successfully initialized cloud pod under %s',A.config_context.get_pod_root_dir())
	def commit(D,message=_A):
		A,B=D.get_latest_revision_of_active_version();C=compute_revision_hash(A,D.config_context.get_obj_store_path())
		if A.parent_ptr!=NIL_PTR:F=B.get_revision(A.parent_ptr);F.assoc_commit.head_ptr=C
		B.update_revision_key(old_key=A.hash_ref,new_key=C);A.hash_ref=C;E=Revision(hash_ref=random_hash(),state_files=set(),parent_ptr=C,creator=A.creator,rid=short_uid(),revision_number=A.revision_number+1);B.revisions.append(E);G=Commit(tail_ptr=A.hash_ref,head_ptr=E.hash_ref,message=message);A.assoc_commit=G;D.object_storage.upsert_objects(B);return A
	def merge_from_remote(A,versions_archive):
		try:merge_from_versions_archive(versions_archive,config_context=A.config_context)
		except zipfile.BadZipFile:raise Exception('Version space is not a zipfile')
	def rename_pod(B,new_pod_name):
		A=new_pod_name
		if B.config_context.pod_exists_locally(A):LOG.warning(f"{A} already exists locally");return _C
		B.config_context.rename_pod(A);return _B
	def list_locally_available_pods(A):mkdir(A.config_context.cloud_pods_root_dir);B=[A for A in os.listdir(A.config_context.cloud_pods_root_dir)if not A.endswith('.json')];return B
	def push(C,comment=_A):A,B=C.get_latest_revision_of_active_version();G=B.version_number;H=G+1;E=C._create_service_state_from_state_file_refs(state_file_refs=A.state_files);I=C.config_context.get_version_state_archive_path();ServiceStateMarshaller.marshall_zip_archive(file_path=I,service_state=E);B.hash_ref=E.compute_hash_on_state();B.finalized=_B;B.comment=comment;F=Revision(hash_ref=random_hash(),state_files=A.state_files,parent_ptr=NIL_PTR,creator=A.creator,rid=short_uid(),revision_number=0);D=Version(hash_ref=random_hash(),state_files=set(),parent_ptr=B.hash_ref,creator=A.creator,outgoing_revision_ptrs={F.hash_ref},incoming_revision_ptr=A.hash_ref,version_number=H);D.revisions.append(F);J=Commit(tail_ptr=A.hash_ref,head_ptr=D.hash_ref,message='Finalizing commit');A.assoc_commit=J;C.object_storage.upsert_objects(B,D);K=C.config_context.metamodel_file(A.revision_number);C.commit_metamodel_utils.create_metamodel_archive(B,overwrite=_B,metamodels_file=K);return B
	def set_pod_context(A,pod_name):A.config_context.set_pod_context(pod_name)
	def get_revision_metamodel(C,revision=_A):
		A=revision
		if not A:A,E=C.get_latest_revision_of_active_version()
		if not A.metamodel_file:return{}
		D=C.config_context.get_obj_file_path(A.metamodel_file);B=load_file(D);B=json.loads(to_str(B));return B
	def create_state_file_from_fs(C,file_name,service,region,root,account_id=_A,object=_A,rel_path=_A):
		E=region;D=service;A=account_id
		if A is _A:A=TEST_AWS_ACCOUNT_ID
		B=hashlib.sha1(object).hexdigest();F=C.config_context.get_obj_file_path(B);save_file(file=F,content=object);G=StateFileRef(hash_ref=B,rel_path=rel_path or f"{root}/{A}/{D}/{E}",file_name=file_name,size=len(object),service=D,region=E,account_id=A);C._add_state_file_to_expansion_point(G);return B
	def _create_state_file_from_blob(B,blob):
		D=random_hash();A=B.config_context.get_obj_file_path(D)
		if not isinstance(blob,(str,bytes)):raise Exception('Blob is neither type str or bytes')
		save_file(A,blob);C=compute_file_hash(A);E=B.config_context.get_obj_file_path(C);os.rename(A,E);return C
	def _get_state_file_path(B,key):
		A=B.config_context.get_obj_file_path(key)
		if os.path.isfile(A):return A
		LOG.warning(f"No state file with found with key: {key}")
	def _add_state_file_to_expansion_point(A,state_file):B=state_file;C,E=A.get_latest_revision_of_active_version();D=set(filter(lambda sf:not sf.congruent(B),C.state_files));D.add(B);C.state_files=D;A.object_storage.upsert_objects(E)
	def create_versions_archive(A):B=os.path.join(A.config_context.get_pod_root_dir(),VERSIONS_ARCHIVE);rm_rf(B);C=zip_directories(zip_dest=B,directories=A.config_context.get_version_space_dir_paths());return C
	def get_max_version(A):
		B=A.get_max_version_no()
		if B:return A.object_storage.get_version(B)
	def get_max_version_no(A):return A.config_context.get_max_version_number()
	def get_latest_revision_of_active_version(A):C=A.config_context.get_current_active_version_number();B=A.object_storage.get_version(C);D=B.get_latest_revision();return D,B
	def get_state_archive_from_state_files(B,version=_A):
		A=version
		if not A:F,A=B.get_latest_revision_of_active_version()
		C=ServiceState()
		for D in A.revisions_with_commit:E=B._create_service_state_from_state_file_refs(state_file_refs=D.state_files);C.put_service_state(E)
		return ServiceStateMarshaller.marshall(state=C)
	def push_overwrite(A,version,comment):
		C=version;D,H=A.get_latest_revision_of_active_version()
		if C>A.get_max_version_no():LOG.debug('Attempted to overwrite a non existing version.. Aborting');return _C
		B=A.get_version_by_number(C);E=A._create_service_state_from_state_file_refs(state_file_refs=D.state_files);F=A.config_context.get_version_state_archive_path();ServiceStateMarshaller.marshall_zip_archive(file_path=F,service_state=E);G=A.config_context.metamodel_file(D.revision_number);A.commit_metamodel_utils.create_metamodel_archive(B,overwrite=_B,metamodels_file=G);B.comment=comment;A.object_storage.upsert_objects(B);return _B
	def _create_service_state_from_state_file_refs(C,state_file_refs):
		A=ServiceState()
		for B in state_file_refs:
			D=B.rel_path.startswith(API_STATES_DIR)
			if D:E=C._create_backend_state_from_state_file(B);A.put_backend(E)
			else:C._add_assets_from_state_file(B,A)
		return A
	def _create_backend_state_from_state_file(B,state_file):A=state_file;C=ServiceKey(account_id=A.account_id,region=A.region,service=A.service);D=B.object_storage.get_state_file_location_by_key(A.hash_ref);E=load_file(file_path=D,mode='rb');return BackendState(key=C,backends={A.file_name:E})
	def _add_assets_from_state_file(B,state_file,service_state):A=state_file;C=B.object_storage.get_state_file_location_by_key(A.hash_ref);D=load_file(file_path=C,mode='rb');service_state.put_asset(service_name=A.service,asset_name=A.rel_path,asset_value=D)
	def set_active_version(A,version_no,commit_before=_C):
		B=version_no;C=A.config_context.list_known_versions()
		for D in C:
			if D==B:
				if commit_before:A.commit()
				return _B
		LOG.info(f"Version with number {B} not found");return _C
	def get_version_by_number(B,version_no):
		A=version_no;C=B.config_context.list_known_versions()
		if A not in C:LOG.warning('Could not find version number %s',A);return
		return B.object_storage.get_version(A)
	def list_versions(A):B=A.config_context.list_known_versions();C=[A.object_storage.get_version(B)for B in B];return C
	def get_version_summaries(A):
		def B(version):
			A=version;D=str(A.version_number);E=A.creator or'Unknown-Creator';B=A.comment;C=[D,E]
			if B:C.append(B)
			return', '.join(C)
		C=A.list_versions();D=[B(A)for A in C];return D
	def list_version_commits(C,version_no):
		D=version_no
		if D==-1:A=C.get_max_version()
		else:A=C.get_version_by_number(D)
		if not A:return[]
		E=[];B=A.get_revision(A.incoming_revision_ptr)
		if not B:B=A.revisions[0]
		while B:
			F=B.assoc_commit
			if F:E.append(F)
			B=A.get_revision(B.parent_ptr)
		return E
	def add_assets_to_pod(B,assets_root_paths):
		for A in assets_root_paths:
			C=os.path.join(B.config_context.get_assets_root_path(),os.path.basename(A))
			try:cp_r(src=A,dst=C)
			except Exception as D:LOG.warning('Failed to copy assets for %s: %s',A,D)
	def upload_pod_to_pre_signed_urls(A,pre_signed_urls):B=pre_signed_urls;C=B.get('versions_archive_url');D=A.create_versions_archive();A._upload(C,D);E=B.get('state_archive_url');F=A.config_context.get_version_state_archive();A._upload(E,F);G=B.get('metadata_archive_url');H=A.config_context.get_version_meta_archive();A._upload(G,H)
	@staticmethod
	def _upload(pre_signed_url,content_path):
		A=content_path
		if A is _A:return
		B=load_file(A,mode='rb');upload_content(pre_signed_url,B)
def upload_content(pre_signed_url,zip_data_content):
	A=safe_requests.put(pre_signed_url,data=zip_data_content)
	if not A.ok:raise Exception(f"Unable to upload pod state to S3 (code {A.status_code}): {A.content}")