_A=None
import glob,logging,os,re,shutil,tempfile,typing
from typing import Dict,List,Optional,Set,Tuple
from urllib.parse import urlparse
from localstack.constants import LOCALHOST
from localstack.utils.files import mkdir,rm_rf
from localstack.utils.numbers import is_number
from localstack.utils.strings import short_uid
from requests import Response
from localstack_ext.bootstrap.pods.remote import CloudPodsRemote
if typing.TYPE_CHECKING:from dxf import DXF;from oras.client import OrasClient
LOG=logging.getLogger(__name__)
class CloudPodsRemoteOras(CloudPodsRemote):
	@classmethod
	def protocols(A):return{'oras'}
	def list_pods(A):
		D=A._registry_client();E=D.list_repos();B=[]
		for C in E:F=A.get_max_version(C);B.append({'pod_name':C,'max_version':F})
		return B
	def is_registered(A,pod_name):return True
	def get_max_version(B,pod_name):
		C=pod_name;E,G=B._client()
		try:
			F=B._get_target(C);A=E.get_tags(F);A=[int(A)for A in A if is_number(A)]
			if A:return sorted(A)[-1]
		except Exception as D:
			if'Not Found'not in str(D):LOG.info("Unable to get max version for cloud pod '%s': %s",C,D)
		return 0
	def register_remote(A,pod_name,ci_pod=_A):return True
	def push_pod(A,pod_name,version,overwrite=False):
		D=pod_name;F,L=A._client();G=A.pods_api.config_context.get_version_state_archive();H=A.pods_api.create_versions_archive();I={f"{D}:{version}":G,f"{D}:versions":H};C=f"tmp-cloud-pod-{short_uid()}";mkdir(C)
		try:
			for(B,J)in I.items():E=os.path.join(C,f"{B.replace(':','-')}.zip");shutil.copyfile(J,E);K={};B=A._get_target(B);F.push(files=[E],target=B,manifest_annotations=K)
		finally:rm_rf(C)
	def pull_versions(A,pod_name,required_versions):
		D=pod_name;F,K=A._client();G={}
		with tempfile.TemporaryDirectory()as B:
			for C in required_versions:
				try:E=A._get_target(f"{D}:{C}");F.pull(outdir=B,target=E);H=glob.glob(os.path.join(B,f"*-{C}.zip"))[0];G[C]=H
				except Exception as I:LOG.debug('Unable to pull version %s for cloud pod %s: %s',C,D,I)
			E=A._get_target(f"{D}:versions");F.pull(outdir=B,target=E);J=glob.glob(os.path.join(B,'*-versions.zip'))[0];A.pods_api.merge_from_remote(versions_archive=J)
	def _client(C):
		from oras.client import OrasClient as D;E=C.remote_config.remote_url;A=urlparse(E);I=re.sub('^oras://','',E);F=A.netloc.startswith(LOCALHOST);G,H=C._get_basic_auth()
		if G and H:J=A.netloc.split('@')[-1];B=D(hostname=J,insecure=F);B.set_basic_auth(G,H)
		else:B=D(hostname=A.netloc,insecure=F)
		return B,I
	def _registry_client(C):
		from dxf import DXF,DXFBase;A=C.remote_config.remote_url;A=A.replace('oras://','http://');H=urlparse(A);D=H.netloc;E,F=C._get_basic_auth()
		def I(base,response):base.authenticate(E,F,response=response)
		B=_A
		if E and F:B=I
		try:G=DXF(D,repo='',auth=B);G.api_version_check();return G
		except Exception as J:
			if'SSLError'in str(J):return DXF(D,repo='',insecure=True,auth=B)
			raise
	def _get_basic_auth(B):
		C=B.remote_config.remote_url;A=urlparse(C)
		if'@'not in A.netloc:return _A,_A
		D,E,H=A.netloc.partition('@');F,E,G=D.partition(':');return F,G
	def _get_target(C,relative_target):
		A=relative_target;D=C.remote_config.remote_url;E=urlparse(D);B=E.path.strip('/')
		if B:return f"{B}/{A}"
		return A