_A=None
import json,logging,os,re,threading,zipfile
from typing import List,Optional,Union
from localstack import config as localstack_config
from localstack_ext.bootstrap import auth
from localstack_ext.bootstrap.pods.constants import ASSETS_ROOT_DIR,COMMIT_FILE,COMPRESSION_FORMAT,DEFAULT_POD_DIR,META_ZIP,OBJ_STORE_DIR,STATE_ZIP,VERSION_SPACE_DIRS,VERSIONS_DIR
LOCK_TYPE=type(threading.Lock())
RLOCK_TYPE=type(threading.RLock())
LOG=logging.getLogger(__name__)
class PodsConfigContext:
	def __init__(A,pods_root_dir=_A,pod_name=_A):A.cloud_pods_root_dir=pods_root_dir or A.get_pods_root_dir();A.pod_name=pod_name;A.user=_A
	@property
	def pod_root_dir(self):
		A=self
		if not A.pod_name:raise Exception('Unable to determine pod root dir as pod name is not configured')
		return os.path.join(A.cloud_pods_root_dir,A.pod_name)
	@classmethod
	def get_pod_config_dir(A,pod_name):return os.path.join(A.get_pods_root_dir(),pod_name)
	@classmethod
	def get_pods_root_dir(A):return os.environ.get('POD_DIR')or os.path.join(localstack_config.CONFIG_DIR,DEFAULT_POD_DIR)
	def get_pod_context(A):return os.path.basename(A.pod_root_dir)
	def get_context_user(A):return A.user
	def get_pod_root_dir(A):return A.pod_root_dir
	def get_obj_store_path(A):return os.path.join(A.pod_root_dir,OBJ_STORE_DIR)
	def get_versions_path(A):return os.path.join(A.pod_root_dir,VERSIONS_DIR)
	def get_assets_root_path(A):return os.path.join(A.pod_root_dir,ASSETS_ROOT_DIR)
	def get_version_meta_archive_path(B,with_format=True):
		A=os.path.join(B.get_pod_root_dir(),META_ZIP)
		if not with_format:return A
		return f"{A}.{COMPRESSION_FORMAT}"
	def get_version_state_archive_path(B,with_format=True):
		A=os.path.join(B.get_pod_root_dir(),STATE_ZIP)
		if not with_format:return A
		return f"{A}.{COMPRESSION_FORMAT}"
	def is_initialized(A):return A.pod_root_dir and os.path.isdir(A.pod_root_dir)
	def get_current_active_version_number(A):return A._get_storage_provider().get_current_active_version_number()
	def get_max_version_number(B):
		A=B._get_storage_provider().get_available_versions()
		if A:return A[-1]
	def list_known_versions(A):return A._get_storage_provider().get_available_versions()
	def get_obj_file_path(A,key):return os.path.join(A.get_obj_store_path(),key)
	def set_pod_context(A,pod_name):
		B=pod_name;C=auth.get_auth_cache();D=C.get('username','unknown');A.pod_name=B
		if not os.path.isdir(A.pod_root_dir):raise Exception(f"Unable to find local cloud pod named '{B}'")
		A.user=D
	def pod_exists_locally(A,pod_name):return os.path.isdir(os.path.join(A.cloud_pods_root_dir,pod_name))
	def rename_pod(A,new_pod_name):C=A.get_pod_root_dir();B=os.path.join(A.cloud_pods_root_dir,new_pod_name);os.rename(C,B);A.set_pod_context(B)
	def get_pod_name(A):return os.path.basename(A.get_pod_root_dir())
	def get_version_space_dir_paths(A):return[os.path.join(A.get_pod_root_dir(),B)for B in VERSION_SPACE_DIRS]
	def metamodel_file(B,revision,version=_A,absolute=False):
		C=version;A=B.commit_metamodel_file(revision)
		if absolute:
			if C is _A:raise Exception('Missing pod version when constructing revision metamodel file path')
			A=os.path.join(B.metadata_dir(C),A)
		return A
	@staticmethod
	def commit_metamodel_file(commit_no):return COMMIT_FILE.format(commit_no=commit_no)
	def metadata_dir(A,version):return os.path.join(A.get_pod_root_dir(),META_ZIP.format(version_no=version))
	def get_version_meta_archive(B):
		A=B.get_version_meta_archive_path()
		if os.path.isfile(A):return A
	def get_version_state_archive(B):
		A=B.get_version_state_archive_path()
		if os.path.isfile(A):return A
	def _get_storage_provider(A):from localstack_ext.bootstrap.pods.object_storage import get_object_storage_provider as B;return B(A)
def zip_directories(zip_dest,directories):
	A=zip_dest;from localstack.utils.archives import create_zip_file_python as C
	for B in directories:C(content_root=os.path.basename(B),base_dir=B,zip_file=A,mode='a')
	return A
def add_file_to_archive(archive,entry_name,content):
	with zipfile.ZipFile(archive,'a')as A:A.writestr(entry_name,content)
def read_file_from_archive(archive_path,file_name):
	B=file_name;A=archive_path
	try:
		with zipfile.ZipFile(A)as C:D=json.loads(C.read(B));return json.dumps(D)
	except Exception as E:LOG.debug(f"Could not find {B} in archive {A}: {E}")
def is_comma_delimited_list(string):
	A=re.compile('^(\\w+)(,\\s*\\w+)*$')
	if A.match(string)is _A:return False
	return True