_A='<version>'
import glob,logging,os,shutil
from typing import List
from localstack import config
from localstack.constants import MAVEN_REPO_URL
from localstack.packages import InstallTarget,Package
from localstack.packages.core import ArchiveDownloadAndExtractInstaller
from localstack.utils.files import cp_r,file_exists_not_empty
from localstack.utils.strings import short_uid
from localstack_ext import config as ext_config
from localstack_ext.packages.spark import download_and_cache_jar_file,spark_package
LOG=logging.getLogger(__name__)
HIVE_REMOVE_JAR_FILES=['hive-jdbc-handler-*.jar']
ICEBERG_JAR_URL=f"{MAVEN_REPO_URL}/org/apache/iceberg/iceberg-hive-runtime/1.1.0/iceberg-hive-runtime-1.1.0.jar"
HIVE_JAR_FILES=[f"{MAVEN_REPO_URL}/org/postgresql/postgresql/42.5.0/postgresql-42.5.0.jar",f"{MAVEN_REPO_URL}/org/apache/hive/hive-jdbc-handler/3.1.3/hive-jdbc-handler-3.1.3.jar",ICEBERG_JAR_URL]
HIVE_LEGACY_HOME='/usr/local/apache-hive-<version>-bin'
HIVE_LEGACY_DEFAULT_VERSION='2.3.5'
URL_PATTERN_HIVE='https://dlcdn.apache.org/hive/hive-<version>/apache-hive-<version>-bin.tar.gz'
HIVE_DEFAULT_VERSION='2.3.9'
HIVE_VERSIONS=[HIVE_DEFAULT_VERSION,'3.1.3']
class HiveInstaller(ArchiveDownloadAndExtractInstaller):
	def __init__(A,version):super().__init__(name='hive',version=version,extract_single_directory=True)
	def _get_install_marker_path(A,install_dir):return os.path.join(install_dir,'bin','hiveserver2')
	def _get_download_url(A):return URL_PATTERN_HIVE.replace(_A,A.version)
	def is_installed(A):
		if not ext_config.BIGDATA_MONO_CONTAINER:return True
		return super().is_installed()
	def _post_process(R,target):
		C=target;from localstack_ext.packages.hadoop import hadoop_package as D;from localstack_ext.packages.spark import download_additional_jar_files as K;spark_package.install(target=C);D.install(target=C);K();E=get_hive_home_dir();A=os.path.join(E,'lib');L=['hadoop-aws-*.jar','aws-java-sdk-bundle-*.jar'];M=D.get_installer().get_hadoop_home();N=os.path.join(M,'share/hadoop/tools/lib')
		for B in L:
			for F in glob.glob(f"{N}/{B}"):
				G=os.path.join(A,os.path.basename(F))
				if not os.path.exists(G):shutil.copy(F,G)
		for O in HIVE_REMOVE_JAR_FILES:
			B=f"{A}/{O}"
			for P in glob.glob(B):os.remove(P)
		for H in HIVE_JAR_FILES:
			I=os.path.join(A,H.rpartition('/')[2])
			if not file_exists_not_empty(I):Q=download_and_cache_jar_file(H);cp_r(Q,I)
		J=os.path.join(E,'bin/ext/debug.sh')
		if os.path.exists(J):os.remove(J)
class HivePackage(Package):
	def __init__(A,default_version=HIVE_DEFAULT_VERSION):super().__init__(name='Hive',default_version=default_version)
	def get_versions(A):return HIVE_VERSIONS
	def _get_installer(A,version):return HiveInstaller(version)
hive_package=HivePackage()
def get_hive_home_dir(version=None):
	if ext_config.BIGDATA_MONO_CONTAINER:A=hive_package.get_installer(version).get_installed_dir();return A
	return HIVE_LEGACY_HOME.replace(_A,HIVE_LEGACY_DEFAULT_VERSION)
def get_hive_warehouse_dir():
	if ext_config.BIGDATA_MONO_CONTAINER:
		if config.PERSISTENCE:A=config.dirs.data
		else:A=os.path.join(config.TMP_FOLDER,f"hive-{short_uid()}")
		return os.path.join(A,'hive-warehouse')
	return'/user/hive/warehouse'
def get_hive_lib_dir(version=None):return os.path.join(get_hive_home_dir(version),'lib')