_K='Unable to start DNS: %s'
_J='neptune'
_I='transfer'
_H='mediastore'
_G='elasticache'
_F='apigatewayv2'
_E='apigateway'
_D='athena'
_C=True
_B='s3'
_A='rds'
import logging,os
from localstack import config as localstack_config
from localstack.runtime import hooks
from localstack.runtime.exceptions import LocalstackExit
from localstack.runtime.hooks import on_infra_ready
from localstack.utils import net
from localstack.utils.bootstrap import API_DEPENDENCIES,LocalstackContainer,get_enabled_apis
from localstack.utils.container_utils.container_client import VolumeBind
from localstack.utils.docker_utils import container_ports_can_be_bound
from localstack.utils.net import Port
from localstack_ext import config as config_ext
from localstack_ext.bootstrap import licensing,local_daemon
from localstack_ext.bootstrap.licensing import KeyActivationError,is_enterprise
LOG=logging.getLogger(__name__)
EXTERNAL_PORT_APIS=_E,_F,_D,'cloudfront','codecommit','ecs','ecr',_G,_H,_A,_I,'kafka',_J
API_DEPENDENCIES.update({'amplify':[_B,'appsync','cognito'],_E:[_F],_D:['emr'],'docdb':[_A],'ecs':['ecr'],_G:['ec2'],'elb':['elbv2'],'emr':[_D,_B],'glacier':[_B],'glue':[_A],'iot':['iotanalytics','iot-data','iotwireless'],'kinesisanalytics':['kinesis','dynamodb'],_J:[_A],_A:['rds-data'],_H:['mediastore-data'],'redshift':['redshift-data'],'timestream':['timestream-write','timestream-query'],_I:[_B]})
get_enabled_apis.cache_clear()
def api_key_configured():return config_ext.is_api_key_configured()
def modify_edge_port_config():
	if os.environ.get('EDGE_PORT')and not localstack_config.EDGE_PORT_HTTP:LOG.warning(('!! Configuring EDGE_PORT={p} without setting EDGE_PORT_HTTP may lead '+'to issues; better leave the defaults, or set EDGE_PORT=443 and EDGE_PORT_HTTP={p}').format(p=localstack_config.EDGE_PORT))
	else:A=localstack_config.EDGE_PORT;localstack_config.EDGE_PORT=443;localstack_config.EDGE_PORT_HTTP=A
@hooks.on_infra_start(should_load=config_ext.ACTIVATE_PRO)
def add_custom_edge_routes():from localstack.services.edge import ROUTER as A;from localstack_ext.services.xray.routes import store_xray_records as B;A.add('/xray_records',B,methods=['POST'])
@hooks.prepare_host(priority=100,should_load=config_ext.ACTIVATE_PRO)
def activate_pro_key_on_host():
	try:
		with licensing.prepare_environment(raise_exception=_C):LOG.debug('pro activation done')
	except KeyActivationError as A:raise LocalstackExit(reason=A.get_user_friendly(),code=55)
@hooks.prepare_host(should_load=config_ext.ACTIVATE_PRO)
def create_dns_forward():
	try:from localstack_ext.services import dns_server as A;A.setup_network_configuration()
	except Exception as B:LOG.warning(_K,B)
@hooks.on_infra_start(should_load=config_ext.ACTIVATE_PRO)
def start_dns_server():
	try:from localstack_ext.services import dns_server as A;A.start_dns_server(asynchronous=_C)
	except Exception as B:LOG.warning(_K,B)
@hooks.prepare_host(should_load=config_ext.ACTIVATE_PRO)
def start_ec2_daemon():
	try:
		if config_ext.EC2_AUTOSTART_DAEMON:LOG.debug('Starting EC2 daemon...');local_daemon.start_in_background()
	except Exception as A:LOG.warning('Unable to start local daemon process: %s'%A)
@hooks.configure_localstack_container(priority=10,should_load=config_ext.ACTIVATE_PRO)
def configure_pro_container(container):
	G='--expose';F='udp';E='tcp';C=container
	try:
		from localstack_ext.constants import DNS_PORT as A;B=[]
		if config_ext.use_custom_dns():
			H=[Port(A,protocol=E),Port(A,protocol=F)]
			if container_ports_can_be_bound(H):
				if not net.is_port_open(A,protocols=E):B+=['-p','{a}:{p}:{p}'.format(a=config_ext.DNS_ADDRESS,p=A)]
				if not net.is_port_open(A,protocols=F):B+=['-p','{a}:{p}:{p}/udp'.format(a=config_ext.DNS_ADDRESS,p=A)]
			else:LOG.info('Unable to bind port 53 - DNS will only be available within Docker, but not on the host');B+=[G,'{p}'.format(p=A)];B+=[G,'{p}/udp'.format(p=A)]
		C.additional_flags.extend(B)
	except Exception as I:LOG.warning('failed to configure DNS: %s',I)
	modify_edge_port_config();D=os.path.expanduser('~/.kube/config')
	if os.path.exists(D):C.volumes.add(VolumeBind(D,'/root/.kube/config'))
@hooks.on_infra_start(should_load=is_enterprise,priority=100)
def configure_enterprise():from localstack import config as A;LOG.debug('Disabling SSL cert download (enterprise image).');A.SKIP_SSL_CERT_DOWNLOAD=_C
@hooks.on_infra_start(should_load=config_ext.ACTIVATE_PRO,priority=10)
def setup_pro_infra():
	_setup_logging();modify_edge_port_config()
	try:
		with licensing.prepare_environment(raise_exception=_C):
			try:from localstack_ext.services import dns_server as B;B.setup_network_configuration()
			except Exception as A:LOG.warning('error setting up dns server: %s',A)
			try:from localstack_ext.aws.protocol import service_router as C;from localstack_ext.services import edge;from localstack_ext.utils.aws import aws_utils as D;C.patch_service_router();edge.patch_start_edge();patch_start_infra();D.patch_aws_utils();set_default_providers_to_pro()
			except Exception as A:
				if LOG.isEnabledFor(level=logging.DEBUG):LOG.exception('error enabling pro code')
				else:LOG.error('error enabling pro code: %s',A)
	except KeyActivationError as A:raise LocalstackExit(reason=A.get_user_friendly(),code=55)
def set_default_providers_to_pro():
	D='pro';from localstack.services.plugins import SERVICE_PLUGINS as A
	if not config_ext.PROVIDER_FORCE_EXPLICIT_LOADING:
		for(B,E)in localstack_config.SERVICE_PROVIDER_CONFIG._provider_config.items():
			F=A.api_provider_specs[B];C=[A for A in F if A==f"{E}_pro"]
			if C:localstack_config.SERVICE_PROVIDER_CONFIG.set_provider(B,C[0])
	G=A.apis_with_provider(D);localstack_config.SERVICE_PROVIDER_CONFIG.bulk_set_provider_if_not_exists(G,D)
def patch_start_infra():
	from localstack.services import infra as A
	def B(asynchronous,apis,is_in_docker,*A,**B):
		D=config_ext.ENFORCE_IAM
		try:config_ext.ENFORCE_IAM=False;return C(asynchronous,apis,is_in_docker,*A,**B)
		finally:config_ext.ENFORCE_IAM=D
	C=A.do_start_infra;A.do_start_infra=B
@on_infra_ready(should_load=config_ext.ACTIVATE_PRO)
def initialize_health_info():from localstack_ext.utils.persistence import update_persistence_health_info as A;A()
def _setup_logging():A=logging.DEBUG if localstack_config.DEBUG else logging.INFO;logging.getLogger('localstack_ext').setLevel(A);logging.getLogger('asyncio').setLevel(logging.INFO);logging.getLogger('botocore').setLevel(logging.INFO);logging.getLogger('dulwich').setLevel(logging.ERROR);logging.getLogger('hpack').setLevel(logging.INFO);logging.getLogger('jnius.reflect').setLevel(logging.INFO);logging.getLogger('kazoo').setLevel(logging.ERROR);logging.getLogger('kubernetes').setLevel(logging.INFO);logging.getLogger('parquet').setLevel(logging.INFO);logging.getLogger('pyftpdlib').setLevel(logging.INFO);logging.getLogger('pyhive').setLevel(logging.INFO);logging.getLogger('pyqldb').setLevel(logging.INFO);logging.getLogger('redshift_connector').setLevel(logging.INFO);logging.getLogger('websockets').setLevel(logging.INFO);logging.getLogger('Parser').setLevel(logging.CRITICAL);logging.getLogger('postgresql_proxy').setLevel(logging.WARNING);logging.getLogger('intercept').setLevel(logging.WARNING);logging.getLogger('root').setLevel(logging.WARNING);logging.getLogger('').setLevel(logging.WARNING)