_B='latest'
_A='2.0.12'
import logging,os
from typing import List
from localstack.constants import ARTIFACTS_REPO
from localstack.packages import InstallTarget,Package,PackageInstaller
from localstack.packages.core import ExecutableInstaller,PermissionDownloadInstaller
from localstack.utils.files import chown_r
from localstack.utils.platform import get_arch
from localstack.utils.run import is_root,run
LOG=logging.getLogger(__name__)
RULE_ENGINE_INSTALL_URL='https://github.com/whummer/serverless-iot-offline'
MOSQUITTO_DIST_URL=ARTIFACTS_REPO+'/raw/0343ad1997113032295091cdaf5a59f2824a2504/mosquitto/buster/v{version}/{platform}/mosquitto'
class MosquittoPackage(Package):
	def __init__(A):super().__init__('Mosquitto',_A)
	def get_versions(A):return[_A]
	def _get_installer(A,version):return MosquittoPackageInstaller(version)
class MosquittoPackageInstaller(PermissionDownloadInstaller):
	def __init__(A,version):super().__init__('mosquitto',version)
	def _get_download_url(A):return MOSQUITTO_DIST_URL.format(version=A.version,platform=get_arch())
class IoTRuleEnginePackage(Package):
	def __init__(A):super().__init__('IoTRuleEngine',_B)
	def get_versions(A):return[_B]
	def _get_installer(A,version):return IoTRuleEnginePackageInstaller('iot-rule-engine',version)
class IoTRuleEnginePackageInstaller(ExecutableInstaller):
	def _get_install_marker_path(A,install_dir):return os.path.join(install_dir,'node_modules','serverless-iot-offline','query.js')
	def _install(B,target):
		A=B._get_install_dir(target);run(['npm','install','--prefix',A,RULE_ENGINE_INSTALL_URL])
		if is_root():LOG.debug('Setting ownership root:root on %s',A);chown_r(A,'root')
iot_rule_engine_package=IoTRuleEnginePackage()
mosquitto_package=MosquittoPackage()