import inspect,logging,pickle,threading,types
from typing import Any
import requests
from localstack import config
from localstack.config import is_persistence_enabled
from localstack.utils.patch import patch
LOG=logging.getLogger(__name__)
def update_persistence_health_info():
	B=f"{config.get_edge_url()}/_localstack/health";C={'features:persistence':'initialized'if is_persistence_enabled()else'disabled'};A=requests.put(B,json=C,verify=False)
	if not A.ok:LOG.info('Unable to update /_localstack/health endpoint with persistence details: %s %s',A,A.content)
def is_generator(o):return isinstance(o,types.GeneratorType)or inspect.isgeneratorfunction(o)
def is_thread(o):return isinstance(o,threading.Thread)
def is_serializable(o):return not is_generator(o)and not is_thread(o)
@patch(pickle._Pickler.save_dict)
def save_dict(fn,self,obj,*B,**C):
	A=obj
	if isinstance(A,dict):A={B:A for(B,A)in A.items()if is_serializable(A)}
	return fn(self,A,*B,**C)