import os

from localstack.testing.pytest import markers
from localstack.utils.strings import short_uid


@markers.snapshot.skip_snapshot_verify(
    paths=[
        "$..RetentionProperties",  # missing
        "$..MagneticStoreWriteProperties",  # missing
        "$..Schema",  # missing
        "$..KmsKeyId",  # missing
        "$..Table1Ref",  # '<resource:1>|<resource:3>' → '<resource:1>-<resource:3>' ... (expected → actual)
        "$..Table2Ref",  # '<resource:1>|<resource:3>' → '<resource:1>-<resource:3>' ... (expected → actual)
    ]
)
@markers.aws.validated
def test_create_db_tables(deploy_cfn_template, aws_client, snapshot):
    snapshot.add_transformer(snapshot.transform.cloudformation_api())

    db_name = f"db-{short_uid()}"
    table_name1 = f"table-{short_uid()}"

    stack = deploy_cfn_template(
        template_path=os.path.join(
            os.path.dirname(__file__), "../../../templates/timestream_dbs.yaml"
        ),
        parameters={"DbName": db_name, "TableName": table_name1},
    )
    snapshot.match("outputs", stack.outputs)

    describe_database = aws_client.timestream_write.describe_database(DatabaseName=db_name)
    snapshot.match("describe_database", describe_database)

    list_tables = aws_client.timestream_write.list_tables(DatabaseName=db_name)
    # order is a bit hard to predict here because one name is autogenerated
    table_name2 = stack.outputs["Table2AttName"]

    table1 = [t for t in list_tables["Tables"] if t["TableName"] == table_name1][0]
    table2 = [t for t in list_tables["Tables"] if t["TableName"] == table_name2][0]
    snapshot.match("table1", table1)
    snapshot.match("table2", table2)
