from .ec2 import Ec2SecurityGroupReplicator, Ec2SubnetReplicator, Ec2VPCReplicator
from .iam import IamPolicyReplicator
from .kms import KmsKeyReplicator
from .lambda_ import LambdaLayerVersionReplicator
from .secrets_manager import SecretmanagerSecretReplicator
from .ssm import SsmParameterReplicator

RESOURCE_REPLICATORS = {
    resource_replicator.type: resource_replicator
    for resource_replicator in [
        Ec2SecurityGroupReplicator,
        Ec2SubnetReplicator,
        Ec2VPCReplicator,
        IamPolicyReplicator,
        KmsKeyReplicator,
        LambdaLayerVersionReplicator,
        SecretmanagerSecretReplicator,
        SsmParameterReplicator,
    ]
}

__all__ = ["RESOURCE_REPLICATORS"]
