from datetime import datetime
from typing import TypedDict

from localstack.aws.api import RequestContext, ServiceException, ServiceRequest, handler

ClusterName = str
JwtToken = str
String = str


class AccessDeniedException(ServiceException):
    code: str = "AccessDeniedException"
    sender_fault: bool = True
    status_code: int = 400


class ExpiredTokenException(ServiceException):
    code: str = "ExpiredTokenException"
    sender_fault: bool = True
    status_code: int = 400


class InternalServerException(ServiceException):
    code: str = "InternalServerException"
    sender_fault: bool = False
    status_code: int = 500


class InvalidParameterException(ServiceException):
    code: str = "InvalidParameterException"
    sender_fault: bool = True
    status_code: int = 400


class InvalidRequestException(ServiceException):
    code: str = "InvalidRequestException"
    sender_fault: bool = True
    status_code: int = 400


class InvalidTokenException(ServiceException):
    code: str = "InvalidTokenException"
    sender_fault: bool = True
    status_code: int = 400


class ResourceNotFoundException(ServiceException):
    code: str = "ResourceNotFoundException"
    sender_fault: bool = True
    status_code: int = 404


class ServiceUnavailableException(ServiceException):
    code: str = "ServiceUnavailableException"
    sender_fault: bool = False
    status_code: int = 503


class ThrottlingException(ServiceException):
    code: str = "ThrottlingException"
    sender_fault: bool = True
    status_code: int = 429


class AssumeRoleForPodIdentityRequest(ServiceRequest):
    clusterName: ClusterName
    token: JwtToken


Timestamp = datetime


class Credentials(TypedDict, total=False):
    sessionToken: String
    secretAccessKey: String
    accessKeyId: String
    expiration: Timestamp


class AssumedRoleUser(TypedDict, total=False):
    arn: String
    assumeRoleId: String


class PodIdentityAssociation(TypedDict, total=False):
    associationArn: String
    associationId: String


class Subject(TypedDict, total=False):
    namespace: String
    serviceAccount: String


class AssumeRoleForPodIdentityResponse(TypedDict, total=False):
    subject: Subject
    audience: String
    podIdentityAssociation: PodIdentityAssociation
    assumedRoleUser: AssumedRoleUser
    credentials: Credentials


class EksAuthApi:
    service = "eks-auth"
    version = "2023-11-26"

    @handler("AssumeRoleForPodIdentity")
    def assume_role_for_pod_identity(
        self, context: RequestContext, cluster_name: ClusterName, token: JwtToken, **kwargs
    ) -> AssumeRoleForPodIdentityResponse:
        raise NotImplementedError
