_C='events'
_B='spans'
_A=None
from collections.abc import Sequence
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import sqlite
revision:str='443b451f15d0'
down_revision:str|Sequence[str]|_A=_A
branch_labels:str|Sequence[str]|_A=_A
depends_on:str|Sequence[str]|_A=_A
def upgrade()->_A:E='The unique identifier for the event.';D='attributes';C='span_id';B=False;A=True;op.create_table(_B,sa.Column('id',sa.Integer(),primary_key=A,autoincrement=A,comment='The unique identifier for the span.'),sa.Column(C,sa.TEXT(),nullable=B,index=A,unique=A,comment='The unique identifier for the span (16-character hex string)'),sa.Column('trace_id',sa.TEXT(),nullable=B,index=A,comment='The identifier for the trace this span belongs to.'),sa.Column('parent_span_id',sa.TEXT(),nullable=A,index=A,comment='The span_id of the parent span. NULL for root spans.'),sa.Column('start_time_unix_nano',sa.Integer(),nullable=B,index=A,comment='The start time of the span in nanoseconds since the Unix epoch.'),sa.Column('end_time_unix_nano',sa.Integer(),nullable=B,comment='The end time of the span in nanoseconds since the Unix epoch.'),sa.Column('status_code',sa.Integer(),nullable=B,comment='The status of the span (e.g., STATUS_CODE_OK, STATUS_CODE_ERROR).'),sa.Column('status_message',sa.TEXT(),nullable=A,comment='An optional descriptive message for the status.'),sa.Column('kind',sa.Integer(),nullable=B,comment='The span kind usually SPAN_KIND_SERVER'),sa.Column('service_name',sa.TEXT(),nullable=B,index=A,comment='Unique name for the AWS service the span is recorded from'),sa.Column('account_id',sa.TEXT(),nullable=B,comment='The account id of the caller'),sa.Column('region',sa.TEXT(),nullable=B,comment='The region of the service the span is recorded from'),sa.Column('arn',sa.TEXT(),nullable=B,comment='The resource arn'),sa.Column('resource_name',sa.TEXT(),nullable=B,comment='The name of the resource'),sa.Column('operation_name',sa.TEXT(),nullable=B,comment='A human-readable name for the operation the span represents boto api operation'),sa.Column('version',sa.Integer(),nullable=B,comment='The version of the span.'),sa.Column('is_write_operation',sa.Boolean(),index=A,default=B,comment='If the operation triggering the span is a write operation, e.g., PutObject, Invoke, etc.'),sa.Column(D,sqlite.JSON(),nullable=A,comment='A JSON object containing key-value pairs of span attributes.'),sa.Column('resource_attributes',sqlite.JSON(),nullable=A,comment='A JSON object of attributes describing the resource that produced this span.'));op.create_table(_C,sa.Column('id',sa.Integer(),primary_key=A,autoincrement=A,comment=E),sa.Column('event_id',sa.TEXT(),nullable=B,index=A,unique=A,comment=E),sa.Column(C,sa.TEXT(),nullable=B,index=A,comment='Foreign Key. The span_id of the span this event belongs to.'),sa.Column('timestamp_unix_nano',sa.Integer(),nullable=B,index=A,comment='The time the event occurred in nanoseconds since the Unix epoch.'),sa.Column('name',sa.TEXT(),nullable=B,comment="The name of the event operation with optional namespace (e.g., 'log.operation')."),sa.Column(D,sqlite.JSON(),nullable=A,comment='A JSON object containing key-value pairs of event attributes.'),sa.ForeignKeyConstraint([C],['spans.span_id'],ondelete='CASCADE'))
def downgrade()->_A:
	with op.batch_alter_table(_C,schema=_A)as A:A.drop_index(A.f('ix_events_timestamp_unix_nano'));A.drop_index(A.f('ix_events_span_id'));A.drop_index(A.f('ix_events_event_id'))
	op.drop_table(_C)
	with op.batch_alter_table(_B,schema=_A)as A:A.drop_index(A.f('ix_spans_trace_id'));A.drop_index(A.f('ix_spans_start_time_unix_nano'));A.drop_index(A.f('ix_spans_span_id'));A.drop_index(A.f('ix_spans_parent_span_id'));A.drop_index(A.f('ix_spans_service_name'))
	op.drop_table(_B)