_H='apigateway'
_G='apigatewayv2'
_F='apigatewaymanagementapi'
_E='events'
_D='lambda'
_C='next_gen_pro'
_B='legacy_pro'
_A='v2_pro'
import functools
from typing import Callable
from localstack import config,constants
from localstack.aws.forwarder import HttpFallbackDispatcher
from localstack.pro.core import config as config_ext
from localstack.services.moto import MotoFallbackDispatcher
from localstack.services.plugins import PLUGIN_NAMESPACE,Service,ServicePluginAdapter,aws_provider
from plux import PluginSpec
def is_pro_activated():return config.is_env_true(constants.ENV_PRO_ACTIVATED)
def pro_aws_provider(api=None,name='pro',should_load=None,requires_license=False):
	A=should_load;A=A or is_pro_activated
	def B(fn):
		B=api or fn.__name__
		@functools.wraps(fn)
		def C():C=ServicePluginAdapter(api=B,should_load=A,create_service=fn);C.requires_license=requires_license;return C
		return PluginSpec(PLUGIN_NAMESPACE,f"{B}:{name}",factory=C)
	return B
@pro_aws_provider()
def acm():from localstack.services.acm.provider import AcmProvider as A;from localstack.services.moto import MotoFallbackDispatcher as B;C=A();return Service.for_provider(C,dispatch_table_factory=B)
@pro_aws_provider(api='acm-pca')
def acm_pca():from localstack.pro.core.services.acm_pca.provider import AcmPcaProvider as A;from localstack.services.moto import MotoFallbackDispatcher as B;C=A();return Service.for_provider(C,dispatch_table_factory=B)
@pro_aws_provider()
def account():from localstack.pro.core.services.account.provider import AccountProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def amplify():from localstack.pro.core.services.amplify.provider import AmplifyProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def apigatewaymanagementapi():from localstack.pro.core.services.apigatewayv2.next_gen.provider import ApigatewaymanagementapiProviderNextGen as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def apigatewayv2():from localstack.pro.core.services.apigatewayv2.next_gen.provider import ApiGatewayV2ProviderNextGen as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_F,name=_C)
def apigatewaymanagementapi_next_gen():from localstack.pro.core.services.apigatewayv2.next_gen.provider import ApigatewaymanagementapiProviderNextGen as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_G,name=_C)
def apigatewayv2_next_gen():from localstack.pro.core.services.apigatewayv2.next_gen.provider import ApiGatewayV2ProviderNextGen as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_F,name=_B)
def apigatewaymanagementapi_legacy():from localstack.pro.core.services.apigateway.legacy.provider_mgmtapi import ApigatewaymanagementapiProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_G,name=_B)
def apigatewayv2_legacy():from localstack.pro.core.services.apigateway.legacy.provider_v2 import ApiGatewayV2Provider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def appconfig():from localstack.pro.core.services.appconfig.provider import AppconfigProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def appconfigdata():from localstack.pro.core.services.appconfigdata.provider import AppconfigDataProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='application-autoscaling')
def application_autoscaling():from localstack.pro.core.services.applicationautoscaling.provider import ApplicationAutoscalingProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def appsync():from localstack.pro.core.services.appsync.provider import AppSyncProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def athena():from localstack.pro.core.services.athena.provider import AthenaProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def autoscaling():from localstack.pro.core.services.autoscaling.provider import AutoscalingProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def backup():from localstack.pro.core.services.backup.provider import BackupProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def batch():from localstack.pro.core.services.batch.provider import BatchProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(should_load=lambda:is_pro_activated(),requires_license=True)
def bedrock():from localstack.pro.core.services.bedrock.provider import BedrockProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='bedrock-runtime',should_load=lambda:is_pro_activated(),requires_license=True)
def bedrock_runtime():from localstack.pro.core.services.bedrock.provider import BedrockRuntimeProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def ce():from localstack.pro.core.services.ce.provider import CeProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def cloudfront():from localstack.pro.core.services.cloudfront.provider import CloudFrontProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def cloudtrail():from localstack.pro.core.services.cloudtrail.provider import CloudtrailProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def cloudcontrol():from localstack.pro.core.services.cloudcontrol.provider import CloudControlProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(should_load=lambda:is_pro_activated()and config_ext.ENABLE_CODEX)
def codebuild():from localstack.pro.core.services.codebuild.provider import CodeBuildProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def codecommit():from localstack.pro.core.services.codecommit.provider import CodecommitProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(should_load=lambda:is_pro_activated()and config_ext.ENABLE_CODEX)
def codedeploy():from localstack.pro.core.services.codedeploy.provider import CodeDeployProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(should_load=lambda:is_pro_activated()and config_ext.ENABLE_CODEX)
def codepipeline():from localstack.pro.core.services.codepipeline.provider import CodePipelineProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='codestar-connections',should_load=lambda:is_pro_activated()and config_ext.ENABLE_CODEX)
def codestar_connections():from localstack.pro.core.services.codestar_connections.provider import CodeStarConnectionsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='cognito-identity')
def cognito_identity():from localstack.pro.core.services.cognito_identity.provider import CognitoIdentityProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='cognito-idp')
def cognito_idp():from localstack.pro.core.services.cognito_idp.provider import CognitoIdpProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(should_load=lambda:is_pro_activated()and config_ext.ENABLE_DMS,requires_license=True)
def dms():from localstack.pro.core.services.dms.provider import DmsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def docdb():from localstack.pro.core.services.docdb import docdb_api as A;return Service('docdb',start=A.start_docdb)
@pro_aws_provider()
def ec2():from localstack.pro.core.services.ec2.provider import Ec2Provider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def ecr():from localstack.pro.core.services.ecr.provider import EcrProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def ecs():from localstack.pro.core.services.ecs.provider import ECSProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def efs():from localstack.pro.core.services.efs.provider import EfsProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def elasticache():from localstack.pro.core.services.elasticache.provider import ElasticacheProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def elasticbeanstalk():from localstack.pro.core.services.elasticbeanstalk.provider import ElasticBeanstalkProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def elb():from localstack.pro.core.services.elb.provider import ElbProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def elbv2():from localstack.pro.core.services.elbv2.provider import Elbv2Provider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='elastictranscoder')
def elastictranscoder():from localstack.pro.core.services.elastictranscoder.provider import ElastictranscoderProvider as A;from localstack.services.moto import MotoFallbackDispatcher as B;C=A();return Service.for_provider(C,dispatch_table_factory=B)
@pro_aws_provider()
def eks():from localstack.pro.core.services.eks.provider import EksProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def emr():from localstack.pro.core.services.emr.provider import EmrProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='emr-serverless')
def emr_serverless():from localstack.pro.core.services.emr_serverless.provider import EmrServerlessProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def fis():from localstack.pro.core.services.fis.provider import FisProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def glacier():from localstack.pro.core.services.glacier.provider import GlacierProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def glue():from localstack.pro.core.services.glue.provider import GlueProvider as A;B=A();return Service.for_provider(B)
@aws_provider(api='identitystore')
def identitystore():from localstack.pro.core.services.identitystore.provider import IdentitystoreProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def iot():from localstack.pro.core.services.iot.provider import IotProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='iot-data')
def iot_data():from localstack.pro.core.services.iot_data.provider import IotDataProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def iotanalytics():from localstack.pro.core.services.iotanalytics.provider import IotAnalyticsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def iotwireless():from localstack.pro.core.services.iotwireless.provider import IotWirelessProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def kafka():from localstack.pro.core.services.kafka.provider import KafkaProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def kinesisanalytics():from localstack.pro.core.services.kinesisanalytics.provider import KinesisAnalyticsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='kinesisanalyticsv2',name='legacy')
def kinesisanalyticsv2_legacy():from localstack.pro.core.services.kinesisanalyticsv2.legacy.provider import KinesisAnalyticsV2Provider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def kinesisanalyticsv2():from localstack.pro.core.services.kinesisanalyticsv2.provider import KinesisAnalyticsV2Provider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def kinesis():from localstack.services.kinesis.provider import KinesisProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=lambda _provider:HttpFallbackDispatcher(_provider,_provider.get_forward_url))
@pro_aws_provider()
def lakeformation():from localstack.pro.core.services.lakeformation.provider import LakeFormationProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def logs():from localstack.pro.core.services.logs.provider import LogsProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def managedblockchain():from localstack.pro.core.services.managedblockchain.provider import ManagedblockchainProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def mediaconvert():from localstack.pro.core.services.mediaconvert.provider import MediaconvertProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def mediastore():from localstack.pro.core.services.mediastore.provider import MediastoreProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='mediastore-data')
def mediastore_data():from localstack.pro.core.services.mediastore.provider import MediaStoreDataProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def memorydb():from localstack.pro.core.services.memorydb.provider import MemoryDBProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def mwaa():from localstack.pro.core.services.mwaa.provider import MwaaProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def neptune():from localstack.pro.core.services.neptune import neptune_api as A;return Service('neptune',start=A.start_neptune)
@pro_aws_provider()
def organizations():from localstack.pro.core.services.organizations.provider import OrganizationsProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='pinpoint')
def pinpoint():from localstack.pro.core.services.pinpoint.provider import PinpointProvider as A;from localstack.services.moto import MotoFallbackDispatcher as B;C=A();return Service.for_provider(C,dispatch_table_factory=B)
@pro_aws_provider()
def pipes():from localstack.pro.core.services.pipes.provider import PipesProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def qldb():from localstack.pro.core.services.qldb.provider import QldbProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='qldb-session')
def qldb_session():from localstack.pro.core.services.qldb.provider import QldbSessionProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def ram():from localstack.pro.core.services.ram.provider import RamProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def rds():from localstack.pro.core.services.rds.provider import RdsProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='rds',name='v2')
def rds_v2():from localstack.pro.core.services.rds.v2.provider import RdsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='rds-data')
def rds_data():from localstack.pro.core.services.rds_data.provider import RdsDataProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def redshift():from localstack.pro.core.services.redshift.provider import RedshiftProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='redshift-data')
def redshift_data():from localstack.pro.core.services.redshift.provider import RedshiftDataProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def sagemaker():from localstack.pro.core.services.sagemaker.provider import SagemakerProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='sagemaker-runtime')
def sagemaker_runtime():from localstack.pro.core.services.sagemaker.provider import SageMakerRuntimeProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def serverlessrepo():from localstack.pro.core.services.serverlessrepo.provider import ServerlessrepoProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def servicediscovery():from localstack.pro.core.services.servicediscovery.provider import ServicediscoveryProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def ssm():from localstack.pro.core.services.ssm.provider import SsmProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def shield():from localstack.pro.core.services.shield.provider import ShieldProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api='timestream-write')
def timestream_write():from localstack.pro.core.services.timestream.provider import TimestreamWriteProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='timestream-query')
def timestream_query():from localstack.pro.core.services.timestream.provider import TimestreamQueryProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def transfer():from localstack.pro.core.services.transfer.provider import TransferProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def xray():from localstack.pro.core.services.xray.provider import XrayProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def apigateway():from localstack.pro.core.services.apigateway.next_gen.provider import ApigatewayNextGenProviderPro as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api=_H,name=_C)
def apigateway_next_gen():from localstack.pro.core.services.apigateway.next_gen.provider import ApigatewayNextGenProviderPro as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api=_H,name=_B)
def apigateway_legacy():from localstack.pro.core.services.apigateway.legacy.apigateway_extended import ApigatewayExtProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api=_D,name='asf_pro')
def lambda_asf():from localstack.pro.core.services.lambda_.provider import LambdaProviderPro as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_D,name=_A)
def lambda_v2():from localstack.pro.core.services.lambda_.provider import LambdaProviderPro as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_D)
def lambda_():from localstack.pro.core.services.lambda_.provider import LambdaProviderPro as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def cloudformation():from localstack.pro.core.services.cloudformation import cloudformation_extended as A;from localstack.services.cloudformation.provider import CloudformationProvider as B;A.patch_cloudformation();C=B();return Service.for_provider(C)
@pro_aws_provider()
def dynamodb():from localstack.pro.core.services.dynamodb.provider import DynamoDBProviderExt as A;B=A();return Service.for_provider(B,dispatch_table_factory=lambda _provider:HttpFallbackDispatcher(_provider,_provider.get_forward_url))
@pro_aws_provider(api='dynamodb',name=_A)
def dynamodb_v2():from localstack.pro.core.services.dynamodb.v2.provider import DynamoDBProviderExt as A;B=A();return Service.for_provider(B,dispatch_table_factory=lambda _provider:HttpFallbackDispatcher(_provider,_provider.get_forward_url))
@pro_aws_provider(api='dynamodbstreams',name=_A)
def dynamodbstreams_v2():from localstack.services.dynamodbstreams.v2.provider import DynamoDBStreamsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def events():from localstack.pro.core.services.events.provider import EventsProviderPro as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_E,name=_A)
def events_v2():from localstack.pro.core.services.events.provider import EventsProviderPro as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api=_E,name='v1_pro')
def events_v1():from localstack.pro.core.services.events.v1.provider import EventsProviderPro as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider(api=_E,name=_B)
def events_legacy():from localstack.pro.core.services.events.v1.provider import EventsProviderPro as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def mq():from localstack.pro.core.services.mq.provider import MQProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def kms():from localstack.services.providers import kms as A;return A.factory.__wrapped__()
@pro_aws_provider()
def opensearch():from localstack.pro.core.services.opensearch.provider import OpensearchProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def route53():from localstack.pro.core.services.route53.provider import Route53ProviderPro as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def s3():from localstack.pro.core.services.s3.provider import S3ProviderPro as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def ses():from localstack.pro.core.services.ses.provider import SesProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def sesv2():from localstack.pro.core.services.sesv2.provider import Sesv2Provider as A;B=A();return Service.for_provider(B)
@pro_aws_provider()
def sqs():from localstack.pro.core.services.sqs.provider import SqsProvider as A;from localstack.services import edge;from localstack.services.sqs import query_api as B;B.register(edge.ROUTER);C=A();return Service.for_provider(C)
@aws_provider(api='sso-admin')
def sso_admin():from localstack.pro.core.services.sso_admin.provider import SsoAdminProvider as A;B=A();return Service.for_provider(B,dispatch_table_factory=MotoFallbackDispatcher)
@pro_aws_provider()
def stepfunctions():from localstack.services.stepfunctions.provider import StepFunctionsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='stepfunctions',name=_A)
def stepfunctions_v2():from localstack.services.stepfunctions.provider import StepFunctionsProvider as A;B=A();return Service.for_provider(B)
@pro_aws_provider(api='textract')
def textract():from localstack.pro.core.services.textract.provider import TextractProvider as A;from localstack.services.moto import MotoFallbackDispatcher as B;C=A();return Service.for_provider(C,dispatch_table_factory=B)
@pro_aws_provider(api='wafv2')
def wafv2():from localstack.pro.core.services.wafv2.provider import Wafv2Provider as A;from localstack.services.moto import MotoFallbackDispatcher as B;C=A();return Service.for_provider(C,dispatch_table_factory=B)
@pro_aws_provider(name='mock',api='eks')
def eks_mock():from localstack.pro.core.services.eks.provider import EksMockProvider as A;B=A();return Service.for_provider(B)