from localstack.sdk.api_client import ApiClient
from localstack.sdk.configuration import Configuration


class BaseClient:
    """
    A BaseClient creates a configuration and instantiate a ApiClient, which is a generic OpenAPI client automatically
    generated by the openapitools/openapi-generator tool.
    """

    configuration: Configuration
    """The configuration for the base client"""
    _api_client: ApiClient
    """The OpenAPI client"""
    host: str
    """The LocalStack host (http://localhost.localstack.cloud:4566 by default)"""
    auth_token: str | None
    """A client can be injected with a LocalStack auth token. If not provided, the one used to start up the
    LocalStack instance will be used (for the features needing it, e.g., Cloud Pods)."""

    def __init__(self, host: str | None = None, auth_token: str | None = None, **kwargs) -> None:
        """
        Initializes a base client to interact with LocalStack developer endpoint.
        :param host: the host, http://localhost.localstack.cloud:4566 by default.
        :param auth_token: if provided, this token would be used for authentication against platform. It not, the
            LocalStack runtime will use the one used to start the container. The token used determines the Cloud
            Pods identity, i.e., which pods are available.
        """
        self.host = host or "http://localhost.localstack.cloud:4566"
        self.auth_token = auth_token
        self.configuration = Configuration(host=self.host)
        self._api_client = ApiClient(configuration=self.configuration)
