# coding: utf-8

"""
    LocalStack REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 4.11.0
    Contact: info@localstack.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from localstack.sdk.models.replication_request_source_aws_config import ReplicationRequestSourceAwsConfig
from localstack.sdk.models.replication_request_target_aws_config import ReplicationRequestTargetAwsConfig
from typing import Optional, Set
from typing_extensions import Self

class ReplicationRequest(BaseModel):
    """
    ReplicationRequest
    """ # noqa: E501
    replication_type: StrictStr = Field(description="The type of replication job")
    source_aws_config: ReplicationRequestSourceAwsConfig
    target_aws_config: Optional[ReplicationRequestTargetAwsConfig] = None
    __properties: ClassVar[List[str]] = ["replication_type", "source_aws_config", "target_aws_config"]

    @field_validator('replication_type')
    def replication_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['MOCK', 'SINGLE_RESOURCE']):
            raise ValueError("must be one of enum values ('MOCK', 'SINGLE_RESOURCE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReplicationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source_aws_config
        if self.source_aws_config:
            _dict['source_aws_config'] = self.source_aws_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of target_aws_config
        if self.target_aws_config:
            _dict['target_aws_config'] = self.target_aws_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReplicationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "replication_type": obj.get("replication_type"),
            "source_aws_config": ReplicationRequestSourceAwsConfig.from_dict(obj["source_aws_config"]) if obj.get("source_aws_config") is not None else None,
            "target_aws_config": ReplicationRequestTargetAwsConfig.from_dict(obj["target_aws_config"]) if obj.get("target_aws_config") is not None else None
        })
        return _obj


