# coding: utf-8

"""
    LocalStack REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 4.12.0
    Contact: info@localstack.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PodVersionsVersionsInner(BaseModel):
    """
    PodVersionsVersionsInner
    """ # noqa: E501
    created_at: Optional[StrictInt] = Field(default=None, description="Timestamp when the version was created.")
    deleted: Optional[StrictStr] = Field(default=None, description="Deletion timestamp or null if not deleted.")
    description: Optional[StrictStr] = Field(default=None, description="Description of the version.")
    localstack_version: Optional[StrictStr] = Field(default=None, description="Version of LocalStack used.")
    services: Optional[List[StrictStr]] = Field(default=None, description="List of services associated with this version.")
    storage_size: Optional[StrictInt] = Field(default=None, description="Size of storage used by this version.")
    user: Optional[StrictStr] = Field(default=None, description="User associated with this version.")
    user_id: Optional[StrictStr] = Field(default=None, description="ID of the user associated with this version.")
    version: Optional[StrictInt] = Field(default=None, description="Version number.")
    __properties: ClassVar[List[str]] = ["created_at", "deleted", "description", "localstack_version", "services", "storage_size", "user", "user_id", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PodVersionsVersionsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if deleted (nullable) is None
        # and model_fields_set contains the field
        if self.deleted is None and "deleted" in self.model_fields_set:
            _dict['deleted'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PodVersionsVersionsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "deleted": obj.get("deleted"),
            "description": obj.get("description"),
            "localstack_version": obj.get("localstack_version"),
            "services": obj.get("services"),
            "storage_size": obj.get("storage_size"),
            "user": obj.get("user"),
            "user_id": obj.get("user_id"),
            "version": obj.get("version")
        })
        return _obj


