# coding: utf-8

"""
    LocalStack REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 4.13.0
    Contact: info@localstack.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from localstack.sdk.models.sns_platform_endpoint_message import SNSPlatformEndpointMessage
from typing import Optional, Set
from typing_extensions import Self

class SNSPlatformEndpointResponse(BaseModel):
    """
    Response payload for the /_aws/sns/platform-endpoint-messages endpoint
    """ # noqa: E501
    region: StrictStr = Field(description="The AWS region, e.g., us-east-1")
    platform_endpoint_messages: Dict[str, List[SNSPlatformEndpointMessage]] = Field(description="Messages sent to the platform endpoint retrieved via the retrospective endpoint. The endpoint ARN is the key with a list of messages as value. ")
    __properties: ClassVar[List[str]] = ["region", "platform_endpoint_messages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SNSPlatformEndpointResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in platform_endpoint_messages (dict of array)
        _field_dict_of_array = {}
        if self.platform_endpoint_messages:
            for _key_platform_endpoint_messages in self.platform_endpoint_messages:
                if self.platform_endpoint_messages[_key_platform_endpoint_messages] is not None:
                    _field_dict_of_array[_key_platform_endpoint_messages] = [
                        _item.to_dict() for _item in self.platform_endpoint_messages[_key_platform_endpoint_messages]
                    ]
            _dict['platform_endpoint_messages'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SNSPlatformEndpointResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "region": obj.get("region"),
            "platform_endpoint_messages": dict(
                (_k,
                        [SNSPlatformEndpointMessage.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("platform_endpoint_messages", {}).items()
            )
        })
        return _obj


