# coding: utf-8

"""
    LocalStack REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 4.4.0
    Contact: info@localstack.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SNSMessage(BaseModel):
    """
    Message sent via SNS
    """ # noqa: E501
    phone_number: Optional[StrictStr] = Field(default=None, alias="PhoneNumber")
    topic_arn: Optional[StrictStr] = Field(default=None, alias="TopicArn")
    subscription_arn: Optional[StrictStr] = Field(default=None, alias="SubscriptionArn")
    message_id: Optional[StrictStr] = Field(default=None, alias="MessageId")
    message: Optional[StrictStr] = Field(default=None, alias="Message")
    message_attributes: Optional[Dict[str, Any]] = Field(default=None, alias="MessageAttributes")
    message_structure: Optional[StrictStr] = Field(default=None, alias="MessageStructure")
    subject: Optional[StrictStr] = Field(default=None, alias="Subject")
    __properties: ClassVar[List[str]] = ["PhoneNumber", "TopicArn", "SubscriptionArn", "MessageId", "Message", "MessageAttributes", "MessageStructure", "Subject"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SNSMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if topic_arn (nullable) is None
        # and model_fields_set contains the field
        if self.topic_arn is None and "topic_arn" in self.model_fields_set:
            _dict['TopicArn'] = None

        # set to None if subscription_arn (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_arn is None and "subscription_arn" in self.model_fields_set:
            _dict['SubscriptionArn'] = None

        # set to None if message_structure (nullable) is None
        # and model_fields_set contains the field
        if self.message_structure is None and "message_structure" in self.model_fields_set:
            _dict['MessageStructure'] = None

        # set to None if subject (nullable) is None
        # and model_fields_set contains the field
        if self.subject is None and "subject" in self.model_fields_set:
            _dict['Subject'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SNSMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PhoneNumber": obj.get("PhoneNumber"),
            "TopicArn": obj.get("TopicArn"),
            "SubscriptionArn": obj.get("SubscriptionArn"),
            "MessageId": obj.get("MessageId"),
            "Message": obj.get("Message"),
            "MessageAttributes": obj.get("MessageAttributes"),
            "MessageStructure": obj.get("MessageStructure"),
            "Subject": obj.get("Subject")
        })
        return _obj


