# Contributing guide

First of all, thank you for taking the time to contribute! 💛

All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them.  
Please make sure to read the relevant section before making your contribution.

## Table of Contents
- [I Have a Question](#i-have-a-question)
- [I Want To Contribute](#i-want-to-contribute)
  - [Reporting Bugs](#reporting-bugs)
  - [Suggesting Enhancements](#suggesting-enhancements)
  - [Code Contributions](#code-contributions)
  - [Improving The Documentation](#improving-the-documentation)

## I Have a Question
> [!IMPORTANT]
> If you want to ask a question, please take a moment to review the available [Documentation](../../).

For the quickest assistance, please contact the Logz.io Support team using the chat icon located in the bottom-right corner of your Logz.io account.

If you prefer, you can [open an issue on GitHub](../../issues/), and our team will get back to you as soon as possible.


## I Want To Contribute
Reporting bugs and submitting feature requests are important contributions.

### Reporting Bugs
> [!NOTE]
> **Before reporting a bug**, please ensure you are using the latest version.

**When reporting a bug**, please ensure you include the below information:
* Current behavior (issue description)
* Expected behavior
* Steps to reproduce

You can either reach out to Logz.io Support team using the chat icon located in the bottom-right corner of your Logz.io account.

Or if you prefer, you can [open an issue on GitHub](../../issues/), and our team will address it as soon as possible.

### Suggesting Enhancements
You can either reach out to Logz.io Support team using the chat icon located in the bottom-right corner of your Logz.io account.

Or if you prefer, you can [open an issue on GitHub](../../issues/), and our team will address it as soon as possible.


### Code Contributions
1. Checkout a new branch following the naming convention: `bugfix/<issue>` or `feature/<name>`.
2. Make your changes.
3. Test your changes locally.
4. Push your changes and open a new PR.

### Improving The Documentation.
You can either:
1. Reach out to Logz.io Support team using the chat icon located in the bottom-right corner of your Logz.io account.
2. [Open an issue on GitHub](../../issues/), and our team will address it as soon as possible.
3. Open a PR with the needed changes.
   - Checkout a new branch following the naming convention: `doc/<topic>`.
   - Make your changes.
   -  Push your changes and open a new PR.

## Attribution.
This guide is based on the **contributing-gen** ❤️ [Make your own](https://github.com/bttger/contributing-gen)!