import pathlib 
from setuptools import setup, find_packages 
# The directory containing this file 
HERE = pathlib.Path(__file__).parent 
# The text of the README file 
README = (HERE / "README.md").read_text() 
# This call to setup() does all the work 
setup( 
    name="ma_algorithm", 
    version="2.0.0", 
    description="Python Code Implementation for ma_algorithm, including SMA, EMA, SMA with LSTM", 
    long_description=README, 
    long_description_content_type="text/markdown", 
    author_email="ntwty5@gmail.com", 
    license="MIT", 
    classifiers=[ 
        "License :: OSI Approved :: MIT License", 
        "Programming Language :: Python :: 3", 
    ], 
    packages=find_packages(), 
    # dependencies for installing the package 
    install_requires=["numpy", "pandas", "alpha_vantage", "seaborn", "keras", "pandas_datareader"] 
) 
