from unittest.case import skip
import numpy as np
import numpy.testing as nt
import unittest
from machinevisiontoolbox import Image

from pathlib import Path


class TestBlobs(unittest.TestCase):

    def test_blobs1(self):
        # 1 blob: 2x2
        im = Image.String(
            r"""
                    ..........
                    ..........
                    ..........
                    ....##....
                    ....##....
                    ..........
                    ..........
                    ..........
                    ..........
                    ..........
                   """,
            binary=True,
        )
        blobs = im.blobs()

        self.assertEqual(len(blobs), 1)
        self.assertEqual(blobs[0].moments.m00, 1)
        self.assertEqual(blobs[0].perimeter_length, 3)

    def test_blobs2(self):
        # 1 blob: single pixel
        im = Image.String(
            r"""
                    ..........
                    ..........
                    ..........
                    ....#.....
                    ..........
                    ..........
                    ..........
                    ..........
                    ..........
                    ..........
                   """,
            binary=True,
        )
        blobs = im.blobs()

        self.assertEqual(len(blobs), 0)

    def test_blobs3(self):
        # 1 blob: single pixel width line
        # should be zero blobs
        im = Image.String(
            r"""
                    ..........
                    ..........
                    .....#....
                    ....#.....
                    ...#......
                    ..........
                    ..........
                    ..........
                    ..........
                    ..........
                   """,
            binary=True,
        )
        blobs = im.blobs()

        self.assertEqual(len(blobs), 0)

    def test_blobs4(self):
        # 2 blobs: 3x3 and 4x4
        im = Image.String(
            r"""
                    ..........
                    ..###.....
                    ..###.....
                    ..###.....
                    ..........
                    ....####..
                    ....####..
                    ....####..
                    ....####..
                    ..........
                   """,
            binary=True,
        )
        blobs = im.blobs()

        self.assertEqual(len(blobs), 2)
        self.assertEqual(blobs[0].area, 9)
        self.assertEqual(blobs[0].perimeter_length, 11)

        self.assertEqual(blobs[1].area, 4)
        self.assertEqual(blobs[1].perimeter_length, 7)


# ------------------------------------------------------------------------ #
if __name__ == "__main__":

    unittest.main()
