# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: chat.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterator,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .. import sentinel as _sentinel__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class EvaluationContentType(betterproto.Enum):
    MESSAGE = 0
    TEXT = 1
    PARTIAL = 2


@dataclass(eq=False, repr=False)
class ChatCompletionRequest(betterproto.Message):
    params: "ChatCompletionParams" = betterproto.message_field(1)
    application_ref_name: str = betterproto.string_field(2)
    session_id: str = betterproto.string_field(3)
    reference_id: str = betterproto.string_field(4)
    action_type: str = betterproto.string_field(5)
    company_id: int = betterproto.int64_field(6)
    apply_corrections: bool = betterproto.bool_field(7)
    id: int = betterproto.int64_field(8)
    date_created: int = betterproto.int64_field(9)
    request_id: str = betterproto.string_field(10)
    evaluation_enabled: bool = betterproto.bool_field(11)
    auth_info: "ChatCompletionAuth" = betterproto.message_field(12)
    client_version: str = betterproto.string_field(13)


@dataclass(eq=False, repr=False)
class ChatCompletionAuth(betterproto.Message):
    openai_api_key: str = betterproto.string_field(1)
    groq_api_key: str = betterproto.string_field(2)
    override_api_key: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ChatCompletionParams(betterproto.Message):
    messages: List["ChatMessage"] = betterproto.message_field(1)
    model: str = betterproto.string_field(2)
    max_tokens: int = betterproto.int32_field(3)
    response_format: "ResponseFormat" = betterproto.message_field(4)
    temperature: float = betterproto.double_field(5)
    top_p: float = betterproto.double_field(6)
    stop: str = betterproto.string_field(7)
    logprobs: bool = betterproto.bool_field(8)
    top_logprobs: int = betterproto.int32_field(9)
    n: int = betterproto.int32_field(10)
    seed: int = betterproto.int32_field(11)
    stream: bool = betterproto.bool_field(12)
    stream_options: "StreamOptions" = betterproto.message_field(13)
    logit_bias: Dict[str, float] = betterproto.map_field(
        14, betterproto.TYPE_STRING, betterproto.TYPE_DOUBLE
    )
    presence_penalty: float = betterproto.double_field(15)
    frequency_penalty: float = betterproto.double_field(16)
    user: str = betterproto.string_field(17)
    tools: List["Tool"] = betterproto.message_field(18)
    tool_choice: str = betterproto.string_field(19)


@dataclass(eq=False, repr=False)
class ResponseFormat(betterproto.Message):
    type: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class StreamOptions(betterproto.Message):
    include_usage: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class Tool(betterproto.Message):
    type: str = betterproto.string_field(1)
    function: "Function" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Function(betterproto.Message):
    name: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    parameters: Dict[str, str] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )


@dataclass(eq=False, repr=False)
class ChatCompletionResponse(betterproto.Message):
    id: str = betterproto.string_field(1)
    response_id: int = betterproto.int64_field(2)
    object: str = betterproto.string_field(3)
    created: int = betterproto.int64_field(4)
    model: str = betterproto.string_field(5)
    system_fingerprint: str = betterproto.string_field(6)
    choices: List["ChatCompletionChoice"] = betterproto.message_field(7)
    usage: "ChatCompletionUsage" = betterproto.message_field(8)
    request_id: str = betterproto.string_field(9)
    evaluate_response: Optional["EvaluateResponse"] = betterproto.message_field(
        11, optional=True, group="_evaluate_response"
    )


@dataclass(eq=False, repr=False)
class ChatCompletionChoice(betterproto.Message):
    index: int = betterproto.int32_field(1)
    message: "ChatMessage" = betterproto.message_field(2)
    logprobs: List[float] = betterproto.double_field(3)
    finish_reason: str = betterproto.string_field(4)
    is_correction: bool = betterproto.bool_field(5)


@dataclass(eq=False, repr=False)
class ChatMessage(betterproto.Message):
    role: str = betterproto.string_field(1)
    content: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ChatCompletionUsage(betterproto.Message):
    prompt_tokens: int = betterproto.int32_field(1)
    completion_tokens: int = betterproto.int32_field(2)
    total_tokens: int = betterproto.int32_field(3)


@dataclass(eq=False, repr=False)
class ChatCompletionChunk(betterproto.Message):
    id: str = betterproto.string_field(1)
    choices: List["Choice"] = betterproto.message_field(2)
    created: int = betterproto.int64_field(3)
    model: str = betterproto.string_field(4)
    object: str = betterproto.string_field(5)
    system_fingerprint: str = betterproto.string_field(6)
    usage: "ChatCompletionUsage" = betterproto.message_field(7)
    evaluate_response: Optional["EvaluateResponse"] = betterproto.message_field(
        8, optional=True, group="_evaluate_response"
    )


@dataclass(eq=False, repr=False)
class ChoiceDelta(betterproto.Message):
    content: str = betterproto.string_field(1)
    role: str = betterproto.string_field(3)
    tool_calls: List["ToolCall"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ToolCall(betterproto.Message):
    id: str = betterproto.string_field(1)
    type: str = betterproto.string_field(2)
    function: "ToolCallFunction" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ToolCallFunction(betterproto.Message):
    name: str = betterproto.string_field(1)
    arguments: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class Choice(betterproto.Message):
    delta: "ChoiceDelta" = betterproto.message_field(1)
    finish_reason: str = betterproto.string_field(2)
    index: int = betterproto.int32_field(3)
    logprobs: List["LogProbs"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class LogProbs(betterproto.Message):
    content: "LogPropsContent" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class LogPropsContent(betterproto.Message):
    token: str = betterproto.string_field(1)
    logprob: float = betterproto.double_field(2)
    bytes: List[int] = betterproto.int32_field(3)
    top_logprobs: List["LogProbs"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class ChatStorageRequest(betterproto.Message):
    chat_completion_request: "ChatCompletionRequest" = betterproto.message_field(1)
    chat_completion_response: "ChatCompletionResponse" = betterproto.message_field(2)
    evaluate_request: "EvaluateRequest" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class EvaluateRequest(betterproto.Message):
    id: int = betterproto.int64_field(1)
    date_created: int = betterproto.int64_field(2)
    application_id: int = betterproto.int64_field(3)
    application_ref_name: str = betterproto.string_field(4)
    session_id: str = betterproto.string_field(5)
    reference_id: str = betterproto.string_field(6)
    action_type: str = betterproto.string_field(7)
    evaluation_content_type: "EvaluationContentType" = betterproto.enum_field(8)
    eval_results_set: Optional["EvaluateResponse"] = betterproto.message_field(
        10, optional=True, group="_eval_results_set"
    )
    company_id: int = betterproto.int64_field(11)
    evaluation_context: str = betterproto.string_field(13)
    text_content: str = betterproto.string_field(9)
    message_content: List["ChatMessage"] = betterproto.message_field(12)
    request_id: str = betterproto.string_field(14)
    sentinel_id: int = betterproto.int64_field(15)
    fault_description: str = betterproto.string_field(16)
    chat_completion_request: Optional["ChatCompletionRequest"] = (
        betterproto.message_field(17, optional=True, group="_chat_completion_request")
    )
    chat_completion_response: Optional["ChatCompletionResponse"] = (
        betterproto.message_field(18, optional=True, group="_chat_completion_response")
    )
    client_version: str = betterproto.string_field(19)


@dataclass(eq=False, repr=False)
class EvaluateResult(betterproto.Message):
    id: int = betterproto.int64_field(1)
    status: str = betterproto.string_field(2)
    description: str = betterproto.string_field(3)
    confidence: float = betterproto.double_field(4)
    meta: Dict[str, str] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    sentinel_id: int = betterproto.int64_field(6)
    eval_time: int = betterproto.int64_field(7)
    sentinel: "_sentinel__.Sentinel" = betterproto.message_field(8)
    date_created: int = betterproto.int64_field(9)
    usage: "ChatCompletionUsage" = betterproto.message_field(10)


@dataclass(eq=False, repr=False)
class EvaluateResponse(betterproto.Message):
    application_id: int = betterproto.int64_field(3)
    session_id: str = betterproto.string_field(4)
    request_id: int = betterproto.int64_field(5)
    evaluation_results: List["EvaluateResult"] = betterproto.message_field(6)
    evaluation_request_id: str = betterproto.string_field(7)
    evaluation_request: Optional["EvaluateRequest"] = betterproto.message_field(
        8, optional=True, group="_evaluation_request"
    )
    evaluate_summary: str = betterproto.string_field(9)


class EvaluationServiceStub(betterproto.ServiceStub):
    async def evaluate(
        self,
        evaluate_request: "EvaluateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "EvaluateResponse":
        return await self._unary_unary(
            "/chat.EvaluationService/Evaluate",
            evaluate_request,
            EvaluateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def evaluate_realtime(
        self,
        evaluate_request: "EvaluateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["ChatCompletionChunk"]:
        async for response in self._unary_stream(
            "/chat.EvaluationService/EvaluateRealtime",
            evaluate_request,
            ChatCompletionChunk,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class EvaluationServiceBase(ServiceBase):

    async def evaluate(self, evaluate_request: "EvaluateRequest") -> "EvaluateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def evaluate_realtime(
        self, evaluate_request: "EvaluateRequest"
    ) -> AsyncIterator["ChatCompletionChunk"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield ChatCompletionChunk()

    async def __rpc_evaluate(
        self, stream: "grpclib.server.Stream[EvaluateRequest, EvaluateResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.evaluate(request)
        await stream.send_message(response)

    async def __rpc_evaluate_realtime(
        self, stream: "grpclib.server.Stream[EvaluateRequest, ChatCompletionChunk]"
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.evaluate_realtime,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/chat.EvaluationService/Evaluate": grpclib.const.Handler(
                self.__rpc_evaluate,
                grpclib.const.Cardinality.UNARY_UNARY,
                EvaluateRequest,
                EvaluateResponse,
            ),
            "/chat.EvaluationService/EvaluateRealtime": grpclib.const.Handler(
                self.__rpc_evaluate_realtime,
                grpclib.const.Cardinality.UNARY_STREAM,
                EvaluateRequest,
                ChatCompletionChunk,
            ),
        }
