# codegen: frontend, sdk
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field


class Agent(BaseModel):
    id: Optional[int] = -1
    date_created: Optional[float] = 0
    application_id: int
    agent_name: str
    description: Optional[str] = None
    meta: Dict[str, Any] = Field(default_factory=dict)
    state: str = "ENABLED"

    # Additional fields from joins (not in database schema)
    intents: List["ApplicationAction"] = Field(default_factory=list)
    conversation_count: Optional[int] = 0
    intent_count: Optional[int] = 0
    application_name: Optional[str] = None  # For joins with application table


# Import here to avoid circular imports
from maitai.models.application import ApplicationAction

Agent.model_rebuild()
