# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['makenew_serverless_python']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'makenew-serverless-python',
    'version': '2.2.1',
    'description': 'Package skeleton for a Python Serverless project on AWS Lambda.',
    'long_description': 'Serverless Python Project Skeleton\n==================================\n\n|PyPI| |Codecov| |CircleCI|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/makenew-serverless-python.svg\n   :target: https://pypi.python.org/pypi/makenew-serverless-python\n   :alt: PyPI\n.. |Codecov| image:: https://img.shields.io/codecov/c/github/makenew/serverless-python.svg\n   :target: https://codecov.io/gh/makenew/serverless-python\n   :alt: Codecov\n.. |CircleCI| image:: https://img.shields.io/circleci/project/github/makenew/serverless-python.svg\n   :target: https://circleci.com/gh/makenew/serverless-python\n   :alt: CircleCI\n\nPackage skeleton for a Python Serverless project on AWS Lambda.\n\nDescription\n-----------\n\nBootstrap a new Python_ Serverless project in five minutes or less.\n\n.. _Python: https://www.python.org/\n\nFeatures\n~~~~~~~~\n\n- Deploy to `AWS Lambda`_ under a `custom domain`_ with Serverless_.\n- Publishing to PyPI_.\n- Secure dependency management with Poetry_.\n- Linting with Pylint_.\n- Uncompromising code formatting with Black_.\n- pytest_ helps you write better programs.\n- Code coverage reporting with Codecov_.\n- CircleCI_ ready.\n- `Keep a CHANGELOG`_.\n- Consistent coding with EditorConfig_.\n- Badges from Shields.io_.\n\n.. _AWS Lambda: https://aws.amazon.com/lambda/\n.. _Black: https://black.readthedocs.io/en/stable/\n.. _Codecov: https://codecov.io/\n.. _EditorConfig: https://editorconfig.org/\n.. _Keep a CHANGELOG: https://keepachangelog.com/\n.. _PyPI: https://pypi.python.org/pypi\n.. _Pylint: https://www.pylint.org/\n.. _Serverless: https://serverless.com/\n.. _Shields.io: https://shields.io/\n.. _custom domain: https://github.com/amplify-education/serverless-domain-manager\n.. _pytest: https://docs.pytest.org/\n\nBootstrapping a New Project\n~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n1. Create an empty (**non-initialized**) repository on GitHub.\n2. Clone the master branch of this repository with\n\n   ::\n\n       $ git clone --single-branch https://github.com/makenew/serverless-python.git new-serverless-python\n       $ cd new-serverless-python\n\n   Optionally, reset to the latest\n   `release <https://github.com/makenew/serverless-python/releases>`__ with\n\n   ::\n\n       $ git reset --hard v1.2.0\n\n3. Run\n\n   ::\n\n       $ ./makenew.sh\n\n   This will replace the boilerplate, delete itself,\n   remove the git remote, remove upstream tags,\n   and stage changes for commit.\n\n4. Create the required CircleCI environment variables with\n\n   ::\n\n       $ .circleci/envvars.sh\n\n5. Review, commit, and push the changes to GitHub with\n\n   ::\n\n     $ git diff --cached\n     $ git commit -m "Replace makenew boilerplate"\n     $ git remote add origin git@github.com:<user>/<new-serverless-python>.git\n     $ git push -u origin master\n\n6. Ensure the CircleCI build passes,\n   then publish the initial version of the package with\n\n   ::\n\n     $ poetry install\n     $ poetry run bumpversion patch\n     $ git push\n     $ git push --tags\n\n7. Ensure a valid certificate exists in `AWS Certificate Manager`_\n   that matches the custom deployment domains,\n   e.g., this project uses a wildcard certificate for\n   ``*.serverless-python.makenew.razorx.app``.\n   Then trigger a deploy to the test stage with\n\n   ::\n\n     $ npm install\n     $ npm run release:test\n\n.. _AWS Certificate Manager: https://aws.amazon.com/certificate-manager/\n\nUpdating\n~~~~~~~~\n\nIf you want to pull in future updates from this skeleton,\nyou can fetch and merge in changes from this repository.\n\nAdd this as a new remote with\n\n::\n\n    $ git remote rename origin upstream\n\nand then configure your ``origin`` branch as normal.\n\nOtherwise, add this as a new remote with\n\n::\n\n    $ git remote add upstream git@github.com:makenew/serverless-python.git\n\nYou can then fetch and merge changes with\n\n::\n\n    $ git fetch --no-tags upstream\n    $ git merge upstream/master\n\nChangelog\n^^^^^^^^^\n\nNote that ``CHANGELOG.md`` is just a template for this skeleton. The\nactual changes for this project are documented in the commit history and\nsummarized under\n`Releases <https://github.com/makenew/serverless-python/releases>`__.\n\nInstallation\n------------\n\nThis package is registered on the `Python Package Index (PyPI)`_\nas makenew_serverless_python_.\n\nInstall it with\n\n::\n\n    $ poetry install makenew_serverless_python\n\n.. _makenew_serverless_python: https://pypi.python.org/pypi/makenew-serverless-python\n.. _Python Package Index (PyPI): https://pypi.python.org/\n\nDevelopment and Testing\n-----------------------\n\nQuickstart\n~~~~~~~~~~\n\n::\n\n    $ git clone https://github.com/makenew/serverless-python.git\n    $ cd serverless-python\n    $ poetry install\n\nRun each command below in a separate terminal window:\n\n::\n\n    $ make watch\n\nPrimary development tasks are defined in the `Makefile`.\n\nSource Code\n~~~~~~~~~~~\n\nThe `source code`_ is hosted on GitHub.\nClone the project with\n\n::\n\n    $ git clone https://github.com/makenew/serverless-python.git\n\n.. _source code: https://github.com/makenew/serverless-python\n\nRequirements\n~~~~~~~~~~~~\n\nYou will need `Python 3`_ and Poetry_ and Node.js_ with npm_.\nTo run some Serverless commands you will need Docker_.\n\nInstall the development dependencies with\n\n::\n\n    $ poetry install\n    $ npm install\n\n.. _Docker: https://www.docker.com/\n.. _Node.js: https://nodejs.org/\n.. _npm: https://www.npmjs.com/\n.. _Poetry: https://poetry.eustace.io/\n.. _Python 3: https://www.python.org/\n\nTests\n~~~~~\n\nLint code with\n\n::\n\n    $ make lint\n\n\nRun tests with\n\n::\n\n    $ make test\n\nRun tests on chages with\n\n::\n\n    $ make watch\n\nPublishing\n~~~~~~~~~~\n\nUse the bumpversion_ command to release a new version.\nPush the created git tag which will trigger a CircleCI publish job.\n\n.. _bumpversion: https://github.com/peritus/bumpversion\n\nDeployment\n~~~~~~~~~~\n\nDeployment is triggered on CircleCI when a git tag matching\n``stage.<environment>`` is created or updated.\nUse ``npm run release:<environment>`` to do this automatically, e.g.,\n\n::\n\n  $ npm run release:test\n\nCircleCI Setup\n--------------\n\n*CircleCI should already be configured: this section is for reference only.*\n\nThe following environment variables must be set on CircleCI_:\n\n- ``TWINE_USERNAME``: Username for publishing on PyPI.\n- ``TWINE_PASSWORD``: Password for publishing on PyPI.\n- ``CODECOV_TOKEN``: Codecov token for uploading coverage reports (optional).\n- ``AWS_DEFAULT_REGION``: The AWS region Serverless will deploy to.\n- ``AWS_ACCESS_KEY_ID``: AWS access key ID.\n- ``AWS_SECRET_ACCESS_KEY``: AWS secret access key.\n\nThese may be set manually or by running the script ``./.circleci/envvars.sh``.\n\n.. _CircleCI: https://circleci.com/\n\nContributing\n------------\n\nPlease submit and comment on bug reports and feature requests.\n\nTo submit a patch:\n\n1. Fork it (https://github.com/makenew/serverless-python/fork).\n2. Create your feature branch (`git checkout -b my-new-feature`).\n3. Make changes.\n4. Commit your changes (`git commit -am \'Add some feature\'`).\n5. Push to the branch (`git push origin my-new-feature`).\n6. Create a new Pull Request.\n\nLicense\n-------\n\nThis Serverless project is licensed under the MIT license.\n\nWarranty\n--------\n\nThis software is provided by the copyright holders and contributors "as is" and\nany express or implied warranties, including, but not limited to, the implied\nwarranties of merchantability and fitness for a particular purpose are\ndisclaimed. In no event shall the copyright holder or contributors be liable for\nany direct, indirect, incidental, special, exemplary, or consequential damages\n(including, but not limited to, procurement of substitute goods or services;\nloss of use, data, or profits; or business interruption) however caused and on\nany theory of liability, whether in contract, strict liability, or tort\n(including negligence or otherwise) arising in any way out of the use of this\nsoftware, even if advised of the possibility of such damage.\n',
    'author': 'Evan Sosenko',
    'author_email': 'razorx@evansosenko.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/makenew/serverless-python',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8.1,<3.9.0',
}


setup(**setup_kwargs)
