# coding: utf-8

"""
    Mandolin

    Micro-service to analyze and convert files

    The version of the OpenAPI document: 1.0.1
    Contact: contact@defensive-lab.agency
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mandolin_python_client.models.yara_result import YaraResult
from typing import Optional, Set
from typing_extensions import Self

class AnalyzerResultYaraResult(BaseModel):
    """
    AnalyzerResultYaraResult
    """ # noqa: E501
    success: Optional[StrictBool] = False
    processor_name: StrictStr
    processor_url: StrictStr
    processor_description: Optional[StrictStr] = None
    error: Optional[StrictStr] = None
    error_short: Optional[StrictStr] = None
    metadata: Optional[Dict[str, Any]] = None
    analysis: Optional[YaraResult] = None
    __properties: ClassVar[List[str]] = ["success", "processor_name", "processor_url", "processor_description", "error", "error_short", "metadata", "analysis"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalyzerResultYaraResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of analysis
        if self.analysis:
            _dict['analysis'] = self.analysis.to_dict()
        # set to None if processor_description (nullable) is None
        # and model_fields_set contains the field
        if self.processor_description is None and "processor_description" in self.model_fields_set:
            _dict['processor_description'] = None

        # set to None if error (nullable) is None
        # and model_fields_set contains the field
        if self.error is None and "error" in self.model_fields_set:
            _dict['error'] = None

        # set to None if error_short (nullable) is None
        # and model_fields_set contains the field
        if self.error_short is None and "error_short" in self.model_fields_set:
            _dict['error_short'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if analysis (nullable) is None
        # and model_fields_set contains the field
        if self.analysis is None and "analysis" in self.model_fields_set:
            _dict['analysis'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalyzerResultYaraResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success") if obj.get("success") is not None else False,
            "processor_name": obj.get("processor_name"),
            "processor_url": obj.get("processor_url"),
            "processor_description": obj.get("processor_description"),
            "error": obj.get("error"),
            "error_short": obj.get("error_short"),
            "metadata": obj.get("metadata"),
            "analysis": YaraResult.from_dict(obj["analysis"]) if obj.get("analysis") is not None else None
        })
        return _obj


