# coding: utf-8

"""
    Mandolin

    Micro-service to analyze and convert files

    The version of the OpenAPI document: 1.0.1
    Contact: contact@defensive-lab.agency
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from mandolin_python_client.models.analyzer_result_tika_result import AnalyzerResultTikaResult
from typing import Optional, Set
from typing_extensions import Self

class AnalysisTikaResult(BaseModel):
    """
    AnalysisTikaResult
    """ # noqa: E501
    success: Optional[StrictBool] = False
    content: Optional[StrictStr] = None
    processors: Optional[Dict[str, AnalyzerResultTikaResult]] = None
    __properties: ClassVar[List[str]] = ["success", "content", "processors"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisTikaResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in processors (dict)
        _field_dict = {}
        if self.processors:
            for _key_processors in self.processors:
                if self.processors[_key_processors]:
                    _field_dict[_key_processors] = self.processors[_key_processors].to_dict()
            _dict['processors'] = _field_dict
        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if processors (nullable) is None
        # and model_fields_set contains the field
        if self.processors is None and "processors" in self.model_fields_set:
            _dict['processors'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisTikaResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success") if obj.get("success") is not None else False,
            "content": obj.get("content"),
            "processors": dict(
                (_k, AnalyzerResultTikaResult.from_dict(_v))
                for _k, _v in obj["processors"].items()
            )
            if obj.get("processors") is not None
            else None
        })
        return _obj


